/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.pointcut;

import com.jz.common.redis.auto.cache.annotation.types.delete.TAfterDel;
import com.jz.common.redis.auto.cache.annotation.types.delete.TBeforeDel;
import com.jz.common.redis.auto.cache.command.delete.AfterDelCommand;
import com.jz.common.redis.auto.cache.command.delete.BeforeDelCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.pointcut.BasePointcut;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class DelCachePointcut
extends BasePointcut {
    @Autowired
    private BeforeDelCommand beforeDelCommand;
    @Autowired
    private AfterDelCommand afterDelCommand;

    @PostConstruct
    public void initializerCommand() {
        this.addCacheBean(TBeforeDel.class, this.beforeDelCommand);
        this.addCacheBean(TAfterDel.class, this.afterDelCommand);
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.delete.TBeforeDel)")
    public void tbeforeDel() {
    }

    @Pointcut(value="@annotation(com.jz.common.redis.auto.cache.annotation.types.delete.TAfterDel)")
    public void tafterDel() {
    }

    @Around(value="tbeforeDel() || tafterDel()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        Class<?> serviceClass = pjp.getTarget().getClass();
        TCacheDomain cacheDomain = BeanTool.getCacheDomain(serviceClass);
        if (null == cacheDomain) {
            return pjp.proceed();
        }
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        return this.proceed(cacheDomain, method, pjp);
    }
}

