/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.domain;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import redis.clients.jedis.JedisCluster;

public class HashDomain {
    private JedisCluster jedis;
    private Integer expire;
    private Collection<String> ignore;
    private Collection<Pair<String, Object>> key2Obj;
    private Collection<String> keys;
    private String key;
    private Object obj;
    private String fieldName;
    private Integer incrbyVal;
    private String value;

    private HashDomain() {
    }

    public static HashDomain ofSingle(JedisCluster jedis, String key) {
        return new HashDomain().setJedis(jedis).setKey(key);
    }

    public static HashDomain ofSingle(JedisCluster jedis, String key, Object obj, String[] ignore, Integer expire) {
        return HashDomain.ofSingle(jedis, key).setObj(obj).setIgnore(Arrays.asList(ignore)).setExpire(expire);
    }

    public static HashDomain ofBatch(JedisCluster jedis, Collection<String> keys) {
        return new HashDomain().setJedis(jedis).setKeys(keys);
    }

    public static HashDomain ofBatch(JedisCluster jedis, List<Pair<String, Object>> key2Obj, String[] ignore, Integer expire) {
        return new HashDomain().setJedis(jedis).setKey2Obj(key2Obj).setIgnore(Arrays.asList(ignore)).setExpire(expire);
    }

    public static HashDomain ofIncrbySingle(JedisCluster jedis, String key, String fieldName, Integer incrbyVal) {
        return new HashDomain().setJedis(jedis).setKey(key).setFieldName(fieldName).setIncrbyVal(incrbyVal);
    }

    public static HashDomain ofIncrbyBatch(JedisCluster jedis, Collection<String> keys, String fieldName, Integer incrbyVal) {
        return new HashDomain().setJedis(jedis).setKeys(keys).setFieldName(fieldName).setIncrbyVal(incrbyVal);
    }

    public static HashDomain ofSetSingle(JedisCluster jedis, String key, String fieldName, String value) {
        return new HashDomain().setJedis(jedis).setKey(key).setFieldName(fieldName).setValue(value);
    }

    public static HashDomain ofSetBatch(JedisCluster jedis, Collection<String> keys, String fieldName, String value) {
        return new HashDomain().setJedis(jedis).setKeys(keys).setFieldName(fieldName).setValue(value);
    }

    public JedisCluster getJedis() {
        return this.jedis;
    }

    public HashDomain setJedis(JedisCluster jedis) {
        this.jedis = jedis;
        return this;
    }

    public Integer getExpire() {
        return this.expire;
    }

    public HashDomain setExpire(Integer expire) {
        this.expire = expire;
        return this;
    }

    public Collection<String> getIgnore() {
        return this.ignore;
    }

    public HashDomain setIgnore(Collection<String> ignore) {
        this.ignore = ignore;
        return this;
    }

    public Collection<Pair<String, Object>> getKey2Obj() {
        return this.key2Obj;
    }

    public HashDomain setKey2Obj(Collection<Pair<String, Object>> key2Obj) {
        this.key2Obj = key2Obj;
        return this;
    }

    public Collection<String> getKeys() {
        return this.keys;
    }

    public HashDomain setKeys(Collection<String> keys) {
        this.keys = keys;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public HashDomain setKey(String key) {
        this.key = key;
        return this;
    }

    public Object getObj() {
        return this.obj;
    }

    public HashDomain setObj(Object obj) {
        this.obj = obj;
        return this;
    }

    public Integer getIncrbyVal() {
        return this.incrbyVal;
    }

    public HashDomain setIncrbyVal(Integer incrbyVal) {
        this.incrbyVal = incrbyVal;
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public HashDomain setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public HashDomain setValue(String value) {
        this.value = value;
        return this;
    }
}

