/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.zset;

import com.jz.common.redis.auto.cache.annotation.types.zset.TZrangeByScore;
import com.jz.common.redis.auto.cache.command.zset.ZSetCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.domain.ZSetDomain;
import com.jz.common.redis.auto.cache.storage.ZSetStorage;
import java.util.List;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Tuple;

@Component
public class ZrangeByScoreCommand
extends ZSetCommand<TZrangeByScore> {
    @Override
    protected boolean alwaysExec(TZrangeByScore zrange) {
        return zrange.alwaysExec();
    }

    @Override
    protected int keyArgsIndex(TZrangeByScore zrange) {
        return zrange.keyArgsIndex();
    }

    @Override
    protected boolean existDel(TZrangeByScore zrange) {
        return zrange.existDel();
    }

    @Override
    protected List<Tuple> getSingle(TCacheDomain cache, TZrangeByScore zrange, Object[] args, String singleCacheKey) {
        Integer start = zrange.startArgsIndex() >= 0 ? Integer.valueOf((Integer)args[zrange.startArgsIndex()]) : null;
        Integer size = zrange.sizeArgsIndex() >= 0 ? Integer.valueOf((Integer)args[zrange.sizeArgsIndex()]) : null;
        double minScore = (Double)args[zrange.minScoreArgsIndex()];
        double maxScore = (Double)args[zrange.maxScoreArgsIndex()];
        ZSetDomain rangeScoreDomain = ZSetDomain.ofRangeScore(this.getJedis(cache), singleCacheKey, minScore, maxScore, zrange.dislodgeLeft(), zrange.dislodgeRight(), start, size, zrange.order());
        return ZSetStorage.zrangeByScoreWithScoreForScore(rangeScoreDomain);
    }

    @Override
    protected int startValue(TZrangeByScore zrange, Object[] args) {
        return zrange.startArgsIndex() >= 0 ? (Integer)args[zrange.startArgsIndex()] : -1;
    }
}

