/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.zset;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.domain.ZSetDomain;
import com.jz.common.redis.auto.cache.storage.ZSetStorage;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import redis.clients.jedis.Tuple;

public abstract class ZSetCommand<T extends Annotation>
extends BaseCommand<T> {
    protected abstract boolean alwaysExec(T var1);

    protected abstract int keyArgsIndex(T var1);

    protected abstract boolean existDel(T var1);

    protected abstract List<Tuple> getSingle(TCacheDomain var1, T var2, Object[] var3, String var4);

    protected abstract int startValue(T var1, Object[] var2);

    @Override
    protected Object runCommand(TCacheDomain cache, T t, ProceedingJoinPoint pjp) throws Throwable {
        if (this.alwaysExec(t)) {
            return this.proceed(cache, pjp, t, null);
        }
        int keyArgsIndex = this.keyArgsIndex(t);
        if (keyArgsIndex < 0) {
            return this.getSingle(cache, t, pjp, null, true);
        }
        Pair<String, Collection<String>> keyPair = this.getSourceValForArgs(cache, keyArgsIndex, pjp);
        if (null == keyPair) {
            return this.proceed(cache, pjp, t, null);
        }
        return this.getSingle(cache, t, pjp, (String)keyPair.getLeft(), true);
    }

    private Object getSingle(TCacheDomain cache, T t, ProceedingJoinPoint pjp, String value, boolean proceed) throws Throwable {
        if (cache.getMaxCount() > 0 && this.startValue(t, pjp.getArgs()) >= cache.getMaxCount()) {
            return pjp.proceed();
        }
        List<Tuple> tuples = this.getSingle(cache, t, pjp.getArgs(), BeanTool.getSingle(cache, value, true));
        if (null != tuples) {
            return this.getResultForReturnType(cache, tuples);
        }
        if (!proceed) {
            return null;
        }
        return this.proceed(cache, pjp, t, value);
    }

    private Object proceed(TCacheDomain cache, ProceedingJoinPoint pjp, T t, String value) throws Throwable {
        Object object = pjp.proceed();
        if (null == object) {
            return null;
        }
        Map<String, Double> value2Score = Maps.newLinkedHashMap();
        if (Collection.class.isAssignableFrom(object.getClass())) {
            this.tupleArrayPutMap((Collection)object, value2Score);
        } else if (object.getClass().isArray()) {
            this.tupleArrayPutMap(Lists.newArrayList((Object[])((Tuple[])object)), value2Score);
        } else if (Map.class.isAssignableFrom(object.getClass())) {
            value2Score = (Map)object;
        } else {
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        if (cache.getMaxCount() > 0 && value2Score.size() > cache.getMaxCount()) {
            Lists.newArrayList(value2Score.keySet()).subList(cache.getMaxCount(), value2Score.size()).forEach(value2Score::remove);
        }
        int keyArgsIndex = this.keyArgsIndex(t);
        String tempKey = null;
        if (keyArgsIndex >= 0) {
            tempKey = pjp.getArgs()[keyArgsIndex].toString();
        }
        ZSetStorage.zadd(ZSetDomain.ofAdd(this.getJedis(cache), BeanTool.getSingle(cache, tempKey, true), value2Score, cache.getExpireSec(), this.existDel(t)));
        if (this.alwaysExec(t)) {
            return object;
        }
        Object limitObject = this.getSingle(cache, t, pjp, value, false);
        if (null != limitObject) {
            return limitObject;
        }
        return object;
    }

    private void tupleArrayPutMap(Collection<Tuple> tuples, Map<String, Double> value2Score) {
        for (Tuple tuple : tuples) {
            value2Score.put(tuple.getElement(), tuple.getScore());
        }
    }

    protected Object getResultForReturnType(TCacheDomain cache, List<Tuple> tuples) {
        Class<?> returnType = cache.getCurrentMethod().getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            return tuples;
        }
        if (returnType.isArray()) {
            Tuple[] array = new Tuple[]{};
            return tuples.toArray(array);
        }
        if (Map.class.isAssignableFrom(returnType)) {
            LinkedHashMap value2Score = Maps.newLinkedHashMap();
            for (Tuple tuple : tuples) {
                value2Score.put(tuple.getElement(), tuple.getScore());
            }
            return value2Score;
        }
        throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
    }
}

