/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.set;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.annotation.types.set.TSet;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.SetDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.SetStorage;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class SetCommand
extends BaseCommand<TSet> {
    @Override
    protected Object runCommand(TCacheDomain cache, TSet set, ProceedingJoinPoint pjp) throws Throwable {
        if (set.alwaysExec()) {
            return this.proceed(cache, set, pjp);
        }
        if (set.keyArgsIndex() < 0) {
            return this.getSingle(cache, set, pjp, null);
        }
        Pair<String, Collection<String>> keyPair = this.getSourceValForArgs(cache, set.keyArgsIndex(), pjp);
        if (null == keyPair) {
            return this.proceed(cache, set, pjp);
        }
        if (null != keyPair.getLeft()) {
            return this.getSingle(cache, set, pjp, (String)keyPair.getLeft());
        }
        return this.getBatch(cache, set, pjp, (Collection)keyPair.getRight());
    }

    private Object getSingle(TCacheDomain cache, TSet set, ProceedingJoinPoint pjp, String value) throws Throwable {
        Set<String> resultArray = SetStorage.get(SetDomain.ofGet(this.getJedis(cache), BeanTool.getSingle(cache, value, true)));
        if (null != resultArray) {
            return resultArray;
        }
        return this.proceed(cache, set, pjp);
    }

    private Object getBatch(TCacheDomain cache, TSet set, ProceedingJoinPoint pjp, Collection<String> keys) throws Throwable {
        HashMap key2Values = Maps.newHashMap();
        ArrayList waitProceedKey = Lists.newArrayList();
        for (String tempKey : keys) {
            String cacheKey = BeanTool.getSingle(cache, tempKey, true);
            Set<String> resultArray = SetStorage.get(SetDomain.ofGet(this.getJedis(cache), cacheKey));
            if (null != resultArray) {
                key2Values.put(tempKey, resultArray);
                continue;
            }
            waitProceedKey.add(tempKey);
        }
        if (waitProceedKey.isEmpty()) {
            return key2Values;
        }
        Object object = pjp.proceed(this.replaceArgs(pjp.getArgs(), set.keyArgsIndex(), waitProceedKey));
        if (null == object) {
            return key2Values;
        }
        if (!Map.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        Map tempKey2Values = (Map)object;
        for (String tempKey : tempKey2Values.keySet()) {
            SetStorage.set(SetDomain.ofSet(this.getJedis(cache), BeanTool.getSingle(cache, tempKey, true), (Set)tempKey2Values.get(tempKey), cache.getExpireSec(), set.existDel()));
        }
        key2Values.putAll(tempKey2Values);
        return key2Values;
    }

    private Object proceed(TCacheDomain cache, TSet set, ProceedingJoinPoint pjp) throws Throwable {
        Object object = pjp.proceed();
        if (null == object) {
            return null;
        }
        Set returnSet = null;
        if (!Set.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        returnSet = (Set)object;
        String tempKey = null;
        if (set.keyArgsIndex() >= 0) {
            tempKey = pjp.getArgs()[set.keyArgsIndex()].toString();
        }
        String cacheKey = BeanTool.getSingle(cache, tempKey, true);
        SetStorage.set(SetDomain.ofSet(this.getJedis(cache), cacheKey, returnSet, cache.getExpireSec(), set.existDel()));
        return object;
    }
}

