/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.list;

import com.jz.common.redis.auto.cache.annotation.types.list.TLpop;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.ListDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.ListStorage;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import com.jz.common.utils.collection.ArrayMapTools;
import java.util.Collection;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class LpopCommand
extends BaseCommand<TLpop> {
    @Override
    protected Object runCommand(TCacheDomain cache, TLpop pop, ProceedingJoinPoint pjp) throws Throwable {
        Object[] args = pjp.getArgs();
        String sourceKey = pop.keyArgsIndex() >= 0 ? args[pop.keyArgsIndex()].toString() : null;
        int tempSize = pop.size() != 0 ? pop.size() : Integer.parseInt(args[pop.sizeArgsIndex()].toString());
        List<String> returnArray = ListStorage.lpop(ListDomain.ofPop(this.getJedis(cache), BeanTool.getSingle(cache, sourceKey, true), tempSize));
        if (ArrayMapTools.isEmpty(returnArray)) {
            return returnArray;
        }
        Class<?> returnType = cache.getCurrentMethod().getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            return returnArray;
        }
        if (returnType.isArray()) {
            String[] array = new String[]{};
            return returnArray.toArray(array);
        }
        throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
    }
}

