/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.list;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.ListDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.ListStorage;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class ListCommand
extends BaseCommand<TList> {
    @Override
    protected Object runCommand(TCacheDomain cache, TList list, ProceedingJoinPoint pjp) throws Throwable {
        if (list.alwaysExec()) {
            return this.proceed(cache, list, pjp);
        }
        if (list.keyArgsIndex() < 0) {
            return this.getSingle(cache, list, pjp, null);
        }
        Pair<String, Collection<String>> keyPair = this.getSourceValForArgs(cache, list.keyArgsIndex(), pjp);
        if (null == keyPair) {
            return this.proceed(cache, list, pjp);
        }
        if (null != keyPair.getLeft()) {
            return this.getSingle(cache, list, pjp, (String)keyPair.getLeft());
        }
        return this.getBatch(cache, list, pjp, (Collection)keyPair.getRight());
    }

    private Object getSingle(TCacheDomain cache, TList list, ProceedingJoinPoint pjp, String value) throws Throwable {
        String cacheKey = BeanTool.getSingle(cache, value, true);
        Pair<Integer, Integer> pair = this.getStart2Size(list, pjp);
        if (cache.getMaxCount() > 0 && (Integer)pair.getLeft() >= cache.getMaxCount()) {
            return pjp.proceed();
        }
        List<String> resultArray = ListStorage.getList(ListDomain.ofGet(this.getJedis(cache), cacheKey, (Integer)pair.getLeft(), (Integer)pair.getRight()));
        if (null != resultArray) {
            Class<?> returnType = cache.getCurrentMethod().getReturnType();
            if (Collection.class.isAssignableFrom(returnType)) {
                return resultArray;
            }
            if (returnType.isArray()) {
                String[] array = new String[]{};
                return resultArray.toArray(array);
            }
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        return this.proceed(cache, list, pjp);
    }

    private Object getBatch(TCacheDomain cache, TList list, ProceedingJoinPoint pjp, Collection<String> keys) throws Throwable {
        HashMap key2Values = Maps.newHashMap();
        ArrayList waitProceedKey = Lists.newArrayList();
        for (String tempKey : keys) {
            String cacheKey = BeanTool.getSingle(cache, tempKey, true);
            List<String> resultArray = ListStorage.getList(ListDomain.ofGet(this.getJedis(cache), cacheKey, 0, -1));
            if (null != resultArray) {
                key2Values.put(tempKey, resultArray);
                continue;
            }
            waitProceedKey.add(tempKey);
        }
        if (waitProceedKey.isEmpty()) {
            return key2Values;
        }
        Object object = pjp.proceed(this.replaceArgs(pjp.getArgs(), list.keyArgsIndex(), waitProceedKey));
        if (null == object) {
            return key2Values;
        }
        if (!Map.class.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        Map tempKey2Values = (Map)object;
        for (String tempKey : tempKey2Values.keySet()) {
            ListStorage.setList(ListDomain.ofSet(this.getJedis(cache), BeanTool.getSingle(cache, tempKey, true), (Collection)tempKey2Values.get(tempKey), list.rightPush(), cache.getExpireSec(), list.existDel()));
        }
        key2Values.putAll(tempKey2Values);
        return key2Values;
    }

    private Pair<Integer, Integer> getStart2Size(TList list, ProceedingJoinPoint pjp) {
        if (list.startArgsIndex() < 0 || list.sizeArgsIndex() < 0) {
            return Pair.of((Object)0, (Object)-1);
        }
        Object[] args = pjp.getArgs();
        int start = Integer.parseInt(args[list.startArgsIndex()].toString());
        int size = Integer.parseInt(args[list.sizeArgsIndex()].toString());
        return Pair.of((Object)start, (Object)size);
    }

    private Object proceed(TCacheDomain cache, TList list, ProceedingJoinPoint pjp) throws Throwable {
        int toIndex;
        Object object = pjp.proceed();
        if (null == object) {
            return null;
        }
        boolean isCollection = false;
        List collection = null;
        if (Collection.class.isAssignableFrom(object.getClass())) {
            collection = Lists.newArrayList((Iterable)((Collection)object));
            isCollection = true;
        } else if (object.getClass().isArray()) {
            collection = Lists.newArrayList((Object[])((String[])object));
        } else {
            throw new IllegalArgumentException("invalid return type for [" + this.getClassMethodName(cache) + "]");
        }
        if (cache.getMaxCount() > 0 && collection.size() > cache.getMaxCount()) {
            collection = collection.subList(0, cache.getMaxCount());
        }
        String tempKey = null;
        if (list.keyArgsIndex() >= 0) {
            tempKey = pjp.getArgs()[list.keyArgsIndex()].toString();
        }
        String cacheKey = BeanTool.getSingle(cache, tempKey, true);
        ListStorage.setList(ListDomain.ofSet(this.getJedis(cache), cacheKey, collection, list.rightPush(), cache.getExpireSec(), list.existDel()));
        if (list.startArgsIndex() < 0 || list.sizeArgsIndex() < 0) {
            return object;
        }
        Pair<Integer, Integer> pair = this.getStart2Size(list, pjp);
        int offset = (Integer)pair.getLeft();
        int size = (Integer)pair.getRight();
        int formIndex = offset < 0 ? 0 : offset;
        int n = toIndex = collection.size() >= offset + size ? offset + size : collection.size();
        if (formIndex >= toIndex) {
            return null;
        }
        List subResult = collection.subList(formIndex, toIndex);
        if (isCollection) {
            return subResult;
        }
        String[] tempResultArray = new String[]{};
        return subResult.toArray(tempResultArray);
    }
}

