/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.hash;

import com.jz.common.redis.auto.cache.annotation.types.hash.THashSet;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.HashDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.HashStorage;
import com.jz.common.utils.text.StringTools;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;

@Component
public class HashSetCommand
extends BaseCommand<THashSet> {
    @Override
    protected Object runCommand(TCacheDomain cache, THashSet hashSet, ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        Pair<String, Collection<String>> redisKey = this.getCacheKeyForArgs(cache, hashSet.keyArgsIndex(), pjp);
        if (null == redisKey) {
            return result;
        }
        if (hashSet.useReturn()) {
            this.invokeHashSet(cache, hashSet, pjp, this.getSourceValForObject(cache, result));
            return result;
        }
        if (StringTools.isNotEmptyAndBlank((String)hashSet.value())) {
            this.invokeHashSet(cache, hashSet, pjp, (Pair<String, Collection<String>>)Pair.of((Object)hashSet.value(), null));
            return result;
        }
        this.invokeHashSet(cache, hashSet, pjp, this.getSourceValForArgs(cache, hashSet.valueArgsIndex(), pjp));
        return result;
    }

    private void invokeHashSet(TCacheDomain cache, THashSet hashSet, ProceedingJoinPoint pjp, Pair<String, Collection<String>> pairValue) throws Exception {
        if (null == pairValue || pairValue.getLeft() == null) {
            return;
        }
        String tempValue = (String)pairValue.getLeft();
        Pair<String, Collection<String>> redisKey = this.getCacheKeyForArgs(cache, hashSet.keyArgsIndex(), pjp);
        if (null == redisKey) {
            return;
        }
        if (null != redisKey.getLeft()) {
            HashStorage.hashSetSingle(HashDomain.ofSetSingle(this.getJedis(cache), (String)redisKey.getLeft(), hashSet.fieldName(), tempValue));
            return;
        }
        HashStorage.hashSetBatch(HashDomain.ofSetBatch(this.getJedis(cache), (Collection)redisKey.getRight(), hashSet.fieldName(), tempValue));
    }
}

