/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.hash;

import com.jz.common.redis.auto.cache.annotation.types.hash.THashIncrby;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.HashDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.HashStorage;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class HashIncrbyCommand
extends BaseCommand<THashIncrby> {
    @Override
    protected Object runCommand(TCacheDomain cache, THashIncrby hashIncrby, ProceedingJoinPoint pjp) throws Throwable {
        Object result = pjp.proceed();
        Integer incrbyVal = null;
        incrbyVal = hashIncrby.useIncrbyArgsIndex() ? (Integer)pjp.getArgs()[hashIncrby.incrbyArgsIndex()] : Integer.valueOf(hashIncrby.incrbyVal());
        if (null == incrbyVal || incrbyVal == 0) {
            return result;
        }
        Pair<String, Collection<String>> redisKey = this.getCacheKeyForArgs(cache, hashIncrby.keyArgsIndex(), pjp);
        if (null == redisKey) {
            return result;
        }
        JedisCluster jedis = this.getJedis(cache);
        if (null != redisKey.getLeft()) {
            HashStorage.incrbySingle(HashDomain.ofIncrbySingle(jedis, (String)redisKey.getLeft(), hashIncrby.fieldName(), incrbyVal));
            return result;
        }
        HashStorage.incrbySingle(HashDomain.ofIncrbyBatch(jedis, (Collection)redisKey.getRight(), hashIncrby.fieldName(), incrbyVal));
        return result;
    }
}

