/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.hash;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.redis.auto.cache.annotation.types.hash.THash;
import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.HashDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.HashStorage;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class HashCommand
extends BaseCommand<THash> {
    @Override
    protected Object runCommand(TCacheDomain cache, THash hash, ProceedingJoinPoint pjp) throws Throwable {
        Pair<String, Collection<String>> sourceValues = this.getSourceValForArgs(cache, hash.keyArgsIndex(), pjp);
        if (null == sourceValues) {
            return null;
        }
        if (null != sourceValues.getLeft()) {
            return this.getSingleBussiness(cache, (String)sourceValues.getLeft(), pjp);
        }
        if (null == sourceValues.getRight()) {
            return null;
        }
        return this.getBatchBussiness(cache, hash, pjp, (Collection)sourceValues.getRight());
    }

    private Object getSingleBussiness(TCacheDomain cache, String value, ProceedingJoinPoint pjp) throws Throwable {
        String cacheKey;
        JedisCluster jedisCluster = this.getJedis(cache);
        Object object = HashStorage.getSingle(HashDomain.ofSingle(jedisCluster, cacheKey = BeanTool.getSingle(cache, value, true)), cache.getClazz());
        if (null != object) {
            return object;
        }
        object = pjp.proceed();
        if (null == object) {
            return null;
        }
        HashStorage.setSingle(HashDomain.ofSingle(jedisCluster, cacheKey, object, cache.getIgnoreFieldName(), cache.getExpireSec()));
        return object;
    }

    private Object restoreOriginalSequence(TCacheDomain cache, Collection<?> tempArray, Collection<String> originalKeys) throws Exception {
        HashMap key2Intance = Maps.newHashMap();
        for (Object r : tempArray) {
            key2Intance.put(BeanUtils.getProperty(r, (String)cache.getKeyFieldName()), r);
        }
        ArrayList resultArray = Lists.newArrayList();
        for (String tempKey : originalKeys) {
            if (!key2Intance.containsKey(tempKey)) continue;
            resultArray.add(key2Intance.get(tempKey));
        }
        Class<?> returnType = cache.getCurrentMethod().getReturnType();
        if (returnType.isArray()) {
            Object[] rs = new Object[]{};
            return resultArray.toArray(rs);
        }
        return resultArray;
    }

    private Object getBatchBussiness(TCacheDomain cache, THash hash, ProceedingJoinPoint pjp, Collection<String> originalKeys) throws Throwable {
        List<String> distinctKeys = originalKeys.stream().distinct().collect(Collectors.toList());
        Collection<String> cacheKeys = BeanTool.getBatch(cache, distinctKeys, true);
        List<Object> resultArray = HashStorage.getBatch(HashDomain.ofBatch(this.getJedis(cache), cacheKeys), cache.getClazz());
        if (ArrayMapTools.isEmpty(resultArray)) {
            Collection<Object> invokeResultArray = this.invokeSupplementMethod(cache, hash, pjp, originalKeys);
            if (ArrayMapTools.isEmpty(invokeResultArray)) {
                return null;
            }
            return this.restoreOriginalSequence(cache, invokeResultArray, originalKeys);
        }
        if (resultArray.size() == distinctKeys.size()) {
            return this.restoreOriginalSequence(cache, resultArray, originalKeys);
        }
        ArrayList waitSupplementArray = Lists.newArrayList(distinctKeys);
        for (Object e : resultArray) {
            waitSupplementArray.remove(BeanTool.getSingleForObject(cache, e, false));
        }
        if (ArrayMapTools.isEmpty((Collection)waitSupplementArray)) {
            return this.restoreOriginalSequence(cache, resultArray, originalKeys);
        }
        Collection<Object> supplementResult = this.invokeSupplementMethod(cache, hash, pjp, waitSupplementArray);
        if (ArrayMapTools.isEmpty(supplementResult)) {
            return this.restoreOriginalSequence(cache, resultArray, originalKeys);
        }
        resultArray.addAll(supplementResult);
        return this.restoreOriginalSequence(cache, resultArray, originalKeys);
    }

    private Collection<Object> invokeSupplementMethod(TCacheDomain cache, THash hash, ProceedingJoinPoint pjp, Collection<String> parameter) throws Throwable {
        Object supplementResult = null;
        supplementResult = StringTools.isNotEmptyAndBlank((String)hash.supplementMethodName()) ? this.invokeOtherMethod(hash, pjp.getTarget(), parameter, pjp.getArgs()) : this.invokeSelfMethod(hash, pjp, parameter);
        if (null == supplementResult) {
            return null;
        }
        this.setBatchBussinessData(cache, supplementResult);
        if (supplementResult.getClass().isArray()) {
            return Arrays.asList((Object[])supplementResult);
        }
        return (Collection)supplementResult;
    }

    private Object invokeOtherMethod(THash hash, Object service, Collection<String> parameter, Object[] args) throws Throwable {
        Method[] methods = service.getClass().getDeclaredMethods();
        Method invokeMethod = null;
        for (Method tempMethod : methods) {
            if (!hash.supplementMethodName().equals(tempMethod.getName())) continue;
            invokeMethod = tempMethod;
            break;
        }
        if (invokeMethod == null) {
            throw new IllegalArgumentException("invalid supplement method for [ " + service.getClass().getName() + "]");
        }
        if (invokeMethod.getParameterCount() == 1) {
            Class<?> firstParameter = invokeMethod.getParameterTypes()[0];
            if (!Collection.class.isAssignableFrom(firstParameter) && !firstParameter.isArray()) {
                throw new IllegalArgumentException("invalid supplement method for [ " + service.getClass().getName() + "]");
            }
            if (firstParameter.isArray()) {
                String[] tempArray = new String[]{};
                String[] tempParameter = parameter.toArray(tempArray);
                return invokeMethod.invoke(service, new Object[]{tempParameter});
            }
            return invokeMethod.invoke(service, parameter);
        }
        if (invokeMethod.getParameterCount() == args.length) {
            return invokeMethod.invoke(service, this.replaceArgs(args, hash.keyArgsIndex(), parameter));
        }
        throw new IllegalArgumentException("invalid supplement method for [ " + service.getClass().getName() + "]");
    }

    private Object invokeSelfMethod(THash hash, ProceedingJoinPoint pjp, Collection<String> parameter) throws Throwable {
        return pjp.proceed(this.replaceArgs(pjp.getArgs(), hash.keyArgsIndex(), parameter));
    }

    private void setBatchBussinessData(TCacheDomain cache, Object tempWaitSetObject) throws Exception {
        if (null == tempWaitSetObject) {
            return;
        }
        ArrayList key2Instance = Lists.newArrayList();
        List<Object> tempObjectArray = null;
        tempObjectArray = tempWaitSetObject.getClass().isArray() ? Arrays.asList((Object[])tempWaitSetObject) : (List<Object>)tempWaitSetObject;
        for (Object e : tempObjectArray) {
            if (null == e) continue;
            key2Instance.add(Pair.of((Object)BeanTool.getSingleForObject(cache, e, true), e));
        }
        HashStorage.setBatch(HashDomain.ofBatch(this.getJedis(cache), key2Instance, cache.getIgnoreFieldName(), cache.getExpireSec()));
    }
}

