/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command.delete;

import com.jz.common.redis.auto.cache.command.BaseCommand;
import com.jz.common.redis.auto.cache.domain.DeleteDomain;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.storage.DeleteStorage;
import com.jz.common.utils.text.StringTools;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public abstract class DeleteCommand<E extends Annotation>
extends BaseCommand<E> {
    protected boolean deleteForArgs(TCacheDomain cache, int keyArgsIndex, ProceedingJoinPoint pjp) throws Exception {
        Class<?>[] parameterTypes = cache.getCurrentMethod().getParameterTypes();
        if (keyArgsIndex >= 0 && null != parameterTypes && parameterTypes.length > 0) {
            return this.deleteForPair(cache, keyArgsIndex, this.getCacheKeyForArgs(cache, keyArgsIndex, pjp));
        }
        if (StringTools.isEmptyAndBlank((String)cache.getFixedKey())) {
            return true;
        }
        return DeleteStorage.delSingle(DeleteDomain.ofSingle(this.getJedis(cache), cache.getFixedKey()));
    }

    protected boolean deleteForPair(TCacheDomain cache, int keyArgsIndex, Pair<String, Collection<String>> redisKey) {
        JedisCluster jedisCluster = this.getJedis(cache);
        if (null == redisKey) {
            if (StringTools.isEmptyAndBlank((String)cache.getFixedKey())) {
                return true;
            }
            return DeleteStorage.delSingle(DeleteDomain.ofSingle(jedisCluster, cache.getFixedKey()));
        }
        if (null != redisKey.getLeft()) {
            return DeleteStorage.delSingle(DeleteDomain.ofSingle(jedisCluster, (String)redisKey.getLeft()));
        }
        List<String> distinctKeys = ((Collection)redisKey.getRight()).stream().distinct().collect(Collectors.toList());
        return DeleteStorage.delBatch(DeleteDomain.ofBatch(jedisCluster, distinctKeys));
    }

    @Override
    protected abstract Object runCommand(TCacheDomain var1, E var2, ProceedingJoinPoint var3) throws Throwable;
}

