/*
 * Decompiled with CFR 0.152.
 */
package com.jz.common.redis.auto.cache.command;

import com.google.common.collect.Lists;
import com.jz.common.redis.auto.cache.domain.TCacheDomain;
import com.jz.common.redis.auto.cache.tool.BeanTool;
import com.jz.common.redis.auto.cache.tool.JedisClusterFactoryTool;
import com.jz.common.utils.collection.ArrayMapTools;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisCluster;

public abstract class BaseCommand<T extends Annotation> {
    @Autowired
    private JedisClusterFactoryTool jedisClusterFactoryTool;

    protected Pair<String, Collection<String>> getSourceValForArgs(TCacheDomain cache, int keyArgsIndex, ProceedingJoinPoint pjp) throws Exception {
        return this.getSourceValForObject(cache, pjp.getArgs()[keyArgsIndex]);
    }

    protected Pair<String, Collection<String>> getSourceValForObject(TCacheDomain cache, Object keyArg) throws Exception {
        return this.getForObject(cache, keyArg, false);
    }

    protected Pair<String, Collection<String>> getCacheKeyForArgs(TCacheDomain cache, int keyArgsIndex, ProceedingJoinPoint pjp) throws Exception {
        return this.getCacheKeyForObject(cache, pjp.getArgs()[keyArgsIndex]);
    }

    protected Pair<String, Collection<String>> getCacheKeyForObject(TCacheDomain cache, Object keyArg) throws Exception {
        return this.getForObject(cache, keyArg, true);
    }

    private Pair<String, Collection<String>> getForObject(TCacheDomain cache, Object keyArg, boolean cacheKey) throws Exception {
        if (null == keyArg) {
            return null;
        }
        if (String.class.isAssignableFrom(keyArg.getClass())) {
            return Pair.of((Object)BeanTool.getSingle(cache, keyArg.toString(), cacheKey), null);
        }
        if (null != cache.getClazz() && cache.getClazz().isAssignableFrom(keyArg.getClass())) {
            return Pair.of((Object)BeanTool.getSingleForObject(cache, keyArg, cacheKey), null);
        }
        ArrayList tempKeyArray = null;
        if (keyArg.getClass().isArray()) {
            tempKeyArray = Arrays.asList((Object[])keyArg);
        } else if (Collection.class.isAssignableFrom(keyArg.getClass())) {
            tempKeyArray = Lists.newArrayList((Iterable)((Collection)keyArg));
        } else {
            this.throwException(cache);
        }
        if (ArrayMapTools.isEmpty(tempKeyArray)) {
            return null;
        }
        Class<?> firstClass = tempKeyArray.get(0).getClass();
        if (String.class.isAssignableFrom(firstClass)) {
            return Pair.of(null, BeanTool.getBatch(cache, tempKeyArray, cacheKey));
        }
        if (null != cache.getClazz() && cache.getClazz().isAssignableFrom(keyArg.getClass())) {
            return Pair.of(null, BeanTool.getBatchForObject(cache, tempKeyArray, cacheKey));
        }
        this.throwException(cache);
        return null;
    }

    private void throwException(TCacheDomain cache) throws IllegalArgumentException {
        String throwInfo = "invalid key field type, just support { java.lang.String, java.util.Collection<java.lang.String>, java.lang.String[]";
        if (null != cache.getClazz()) {
            throwInfo = throwInfo + ", " + cache.getClazz().getName();
        }
        throwInfo = throwInfo + " } for [" + this.getClassMethodName(cache) + "]";
        throw new IllegalArgumentException(throwInfo);
    }

    protected JedisCluster getJedis(TCacheDomain cache) {
        JedisCluster jedisCluster = this.jedisClusterFactoryTool.getJedisCluster(cache);
        if (null != jedisCluster) {
            return jedisCluster;
        }
        throw new NullPointerException("not found [" + cache.getJedisBeanName() + "] jedis cluster bean");
    }

    protected abstract Object runCommand(TCacheDomain var1, T var2, ProceedingJoinPoint var3) throws Throwable;

    public Object exec(TCacheDomain cache, ProceedingJoinPoint pjp, Method method, Class<? extends Annotation> annotationClass) throws Throwable {
        cache.setCurrentClass(pjp.getTarget().getClass()).setCurrentMethod(method);
        return this.runCommand(cache, method.getAnnotation(annotationClass), pjp);
    }

    protected Object[] replaceArgs(Object[] args, int keyArgsIndex, Collection<String> parameter) {
        Object requestParmeter = args[keyArgsIndex];
        if (requestParmeter.getClass().isArray()) {
            String[] tempArray = new String[]{};
            args[keyArgsIndex] = parameter.toArray(tempArray);
        } else {
            args[keyArgsIndex] = parameter;
        }
        return args;
    }

    protected String getClassMethodName(TCacheDomain cache) {
        return BeanTool.getClassMethodName(cache, ".");
    }
}

