/*
 * Decompiled with CFR 0.152.
 */
package com.jz.qcloud.tools;

import com.jz.qcloud.beans.QcloudConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.region.Region;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;

public class PresignedUrlTools {
    private QcloudConfig qcloudConfig;

    private PresignedUrlTools() {
    }

    private PresignedUrlTools(QcloudConfig qcloudConfig) {
        this.qcloudConfig = qcloudConfig;
    }

    public static PresignedUrlTools getInstance(QcloudConfig qcloudConfig) {
        return new PresignedUrlTools(qcloudConfig);
    }

    private COSClient createCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.qcloudConfig.getSecretId(), this.qcloudConfig.getSecretKey());
        Region region = new Region(this.qcloudConfig.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public String genPresignedUrl(String identity, String path, boolean needPost) {
        COSClient cosClient = this.createCOSClient();
        String key = path;
        Date expirationDate = new Date(System.currentTimeMillis() + 0x6DDD00L);
        HashMap params = new HashMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("identity", identity);
        HttpMethodName method = needPost ? HttpMethodName.POST : HttpMethodName.PUT;
        URL url = cosClient.generatePresignedUrl(this.qcloudConfig.getBucketName(), key, expirationDate, method, headers, params);
        cosClient.shutdown();
        return url.toString();
    }
}

