package com.jz.qcloud.tools;

import java.util.TreeMap;

import com.jz.qcloud.beans.QcloudConfig;
import com.tencent.cloud.CosStsClient;
import com.tencent.cloud.Response;

/**
 * @Title 提供上传到对象存储的临时凭证
 * @author shaolianjie
 */
public class StsTools {

	private QcloudConfig qcloudConfig;

	private StsTools(QcloudConfig qcloudConfig) {
		this.qcloudConfig = qcloudConfig;
	}

	public static StsTools getInstance(QcloudConfig qcloudConfig) {
		return new StsTools(qcloudConfig);
	}

	/** 获取临时上传token */
	public Response getTemporaryUploadToken(String filePath) throws Exception {
		TreeMap<String, Object> config = new TreeMap<String, Object>();
		// 云 api 密钥 SecretId
		config.put("secretId", qcloudConfig.getSecretId());
		// 云 api 密钥 SecretKey
		config.put("secretKey", qcloudConfig.getSecretKey());

		// 临时密钥有效时长，单位是秒
		config.put("durationSeconds", 7200);

		// 换成你的 bucket
		config.put("bucket", qcloudConfig.getBucketName());
		// 换成 bucket 所在地区
		config.put("region", qcloudConfig.getRegion());

		// 可以通过 allowPrefixes 指定前缀数组, 例子： a.jpg 或者 a/* 或者 * (使用通配符*存在重大安全风险, 请谨慎评估使用)
		config.put("allowPrefixes", new String[] { filePath });

		// 密钥的权限列表。简单上传和分片需要以下的权限，其他权限列表请看
		// https://cloud.tencent.com/document/product/436/31923
		String[] allowActions = new String[] {
				// 简单上传
				"name/cos:PutObject", "name/cos:PostObject",
				// 分片上传
				"name/cos:InitiateMultipartUpload", "name/cos:ListMultipartUploads", "name/cos:ListParts",
				"name/cos:UploadPart", "name/cos:CompleteMultipartUpload" };
		config.put("allowActions", allowActions);

		return CosStsClient.getCredential(config);
	}

}
