/*
 * Decompiled with CFR 0.152.
 */
package com.jz.qcloud.tools;

import com.google.common.collect.Lists;
import com.jz.qcloud.beans.QcloudConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.model.COSObjectSummary;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.ListObjectsRequest;
import com.qcloud.cos.model.ObjectListing;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CosTools {
    private static final Logger logger = LoggerFactory.getLogger(CosTools.class);
    private QcloudConfig qcloudConfig;

    private CosTools() {
    }

    private CosTools(QcloudConfig qcloudConfig) {
        this.qcloudConfig = qcloudConfig;
    }

    public static CosTools getInstance(QcloudConfig qcloudConfig) {
        return new CosTools(qcloudConfig);
    }

    private COSClient createCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.qcloudConfig.getSecretId(), this.qcloudConfig.getSecretKey());
        Region region = new Region(this.qcloudConfig.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public void upload(String localFilePath, String cosFilePath) throws FileNotFoundException {
        logger.info("upload file : {} => {}", (Object)localFilePath, (Object)cosFilePath);
        COSClient cosClient = this.createCOSClient();
        File localFile = new File(localFilePath);
        String bucketName = this.qcloudConfig.getBucketName();
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, cosFilePath, localFile);
        cosClient.putObject(putObjectRequest);
        cosClient.shutdown();
    }

    public List<String> listFiles(String dirPath) {
        COSClient cosClient = this.createCOSClient();
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest();
        listObjectsRequest.setBucketName(this.qcloudConfig.getBucketName());
        if (!dirPath.endsWith("/")) {
            dirPath = String.valueOf(dirPath) + "/";
        }
        listObjectsRequest.setPrefix(dirPath);
        listObjectsRequest.setDelimiter("/");
        listObjectsRequest.setMaxKeys(Integer.valueOf(200));
        ObjectListing objectListing = cosClient.listObjects(listObjectsRequest);
        List cosObjectSummaries = objectListing.getObjectSummaries();
        ArrayList list = Lists.newArrayList();
        for (COSObjectSummary cosObjectSummary : cosObjectSummaries) {
            String key = cosObjectSummary.getKey();
            list.add(key);
        }
        cosClient.shutdown();
        return list;
    }

    public void downloadFile(String filePath, String localPath) throws Throwable {
        COSClient cosClient = this.createCOSClient();
        File downFile = new File(localPath);
        GetObjectRequest getObjectRequest = new GetObjectRequest(this.qcloudConfig.getBucketName(), filePath);
        cosClient.getObject(getObjectRequest, downFile);
        cosClient.shutdown();
    }

    public void delete(String filePath) throws FileNotFoundException {
        logger.info("delete file : {} => {}", (Object)filePath);
        COSClient cosClient = this.createCOSClient();
        cosClient.deleteObject(this.qcloudConfig.getBucketName(), filePath);
        cosClient.shutdown();
    }
}

