/*
 * Decompiled with CFR 0.152.
 */
package com.jz.qcloud.tools;

import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.qcloud.beans.QcloudConfig;
import com.jz.qcloud.beans.TempUploadInfo;
import com.jz.qcloud.beans.UploadConfig;
import com.tencent.cloud.CosStsClient;
import com.tencent.cloud.Response;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class StsTools {
    private QcloudConfig qcloudConfig;

    private StsTools(QcloudConfig qcloudConfig) {
        this.qcloudConfig = qcloudConfig;
    }

    public static StsTools getInstance(QcloudConfig qcloudConfig) {
        return new StsTools(qcloudConfig);
    }

    public TempUploadInfo getTemporaryUploadToken(String identity, String clientFileName, UploadConfig uploadConfig) throws Exception {
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("secretId", this.qcloudConfig.getSecretId());
        config.put("secretKey", this.qcloudConfig.getSecretKey());
        config.put("durationSeconds", 7200);
        config.put("bucket", this.qcloudConfig.getBucketName());
        config.put("region", this.qcloudConfig.getRegion());
        config.put("allowPrefixes", new String[]{uploadConfig.getBasePath()});
        String[] allowActions = new String[]{"name/cos:PutObject", "name/cos:PostObject", "name/cos:InitiateMultipartUpload", "name/cos:ListMultipartUploads", "name/cos:ListParts", "name/cos:UploadPart", "name/cos:CompleteMultipartUpload"};
        config.put("allowActions", allowActions);
        Response response = CosStsClient.getCredential(config);
        String fileId = this.getFileId(identity, clientFileName, uploadConfig);
        String path = uploadConfig.getSaveDir();
        if (!path.startsWith(uploadConfig.getBasePath())) {
            path = String.valueOf(uploadConfig.getBasePath()) + "/" + path;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = String.valueOf(path) + fileId;
        if (StringUtils.isNotEmpty((CharSequence)uploadConfig.getExt())) {
            path = String.valueOf(path) + "." + uploadConfig.getExt();
        }
        String host = "https://" + this.qcloudConfig.getBucketName() + ".cos." + this.qcloudConfig.getRegion() + ".myqcloud.com";
        TempUploadInfo info = TempUploadInfo.of();
        info.setTmpSecretId(response.credentials.tmpSecretId).setTmpSecretKey(response.credentials.tmpSecretKey).setSessionToken(response.credentials.sessionToken).setHost(host).setCosPath(path).setExpire(response.expiredTime);
        if (StringUtils.isNotEmpty((CharSequence)uploadConfig.getCallback())) {
            info.setCallback(this.getCallbackBody(uploadConfig.getCallbackBody(), StringTools.ternary((String)uploadConfig.getCdnHost(), (String)host), fileId, path, uploadConfig.getData(), clientFileName));
        }
        return info;
    }

    private String getFileId(String identity, String clientFileName, UploadConfig tokenConfig) {
        return String.valueOf(StringTools.ternary((String)tokenConfig.getPrefix())) + IdTools.encode((String)(String.valueOf(identity) + StringTools.RandomString.random((int)10))) + StringTools.ternary((String)tokenConfig.getSuffix());
    }

    private String getCallbackBody(String callbackBody, String host, String fileId, String savePath, String data, String clientFileName) throws UnsupportedEncodingException {
        if (StringTools.isNotEmptyAndBlank((String)host)) {
            callbackBody = String.valueOf(callbackBody) + "&host=" + host;
        }
        callbackBody = String.valueOf(callbackBody) + "&fileId=" + fileId + "&path=" + URLEncoder.encode(savePath, "UTF-8") + "&fileName=" + URLEncoder.encode(clientFileName, "UTF-8");
        callbackBody = String.valueOf(callbackBody) + "&mimeType=${mimeType}&imageInfo.format=${imageInfo.format}&imgHeight=${imageInfo.height}&imgWidth=${imageInfo.width}";
        callbackBody = String.valueOf(callbackBody) + "&data=" + StringTools.ternary((String)data);
        return callbackBody;
    }
}

