/*
 * Decompiled with CFR 0.152.
 */
package com.jz.qcloud.tools;

import com.jz.common.utils.jz.IdTools;
import com.jz.common.utils.text.StringTools;
import com.jz.qcloud.beans.PreSignedUploadInfo;
import com.jz.qcloud.beans.QcloudConfig;
import com.jz.qcloud.beans.UploadConfig;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.http.HttpMethodName;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.region.Region;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class PresignedUrlTools {
    private QcloudConfig qcloudConfig;

    private PresignedUrlTools() {
    }

    private PresignedUrlTools(QcloudConfig qcloudConfig) {
        this.qcloudConfig = qcloudConfig;
    }

    public static PresignedUrlTools getInstance(QcloudConfig qcloudConfig) {
        return new PresignedUrlTools(qcloudConfig);
    }

    private COSClient createCOSClient() {
        BasicCOSCredentials cred = new BasicCOSCredentials(this.qcloudConfig.getSecretId(), this.qcloudConfig.getSecretKey());
        Region region = new Region(this.qcloudConfig.getRegion());
        ClientConfig clientConfig = new ClientConfig(region);
        clientConfig.setHttpProtocol(HttpProtocol.https);
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    public PreSignedUploadInfo genPresignedUrl(String identity, String clientFileName, UploadConfig uploadConfig) throws Exception {
        COSClient cosClient = this.createCOSClient();
        String fileId = this.getFileId(identity, clientFileName, uploadConfig);
        String path = uploadConfig.getSaveDir();
        if (!path.startsWith(uploadConfig.getBasePath())) {
            path = String.valueOf(uploadConfig.getBasePath()) + "/" + path;
        }
        if (!path.endsWith("/")) {
            path = String.valueOf(path) + "/";
        }
        path = String.valueOf(path) + fileId;
        if (StringUtils.isNotEmpty((CharSequence)uploadConfig.getExt())) {
            path = String.valueOf(path) + "." + uploadConfig.getExt();
        }
        String key = path;
        Date expirationDate = new Date(System.currentTimeMillis() + 0x6DDD00L);
        HashMap params = new HashMap();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("identity", identity);
        HttpMethodName method = uploadConfig.isPost() ? HttpMethodName.POST : HttpMethodName.PUT;
        URL url = cosClient.generatePresignedUrl(this.qcloudConfig.getBucketName(), key, expirationDate, method, headers, params);
        cosClient.shutdown();
        String host = "https://" + this.qcloudConfig.getBucketName() + ".cos." + this.qcloudConfig.getRegion() + ".myqcloud.com";
        PreSignedUploadInfo info = PreSignedUploadInfo.of();
        info.setUrl(url.toString());
        if (StringUtils.isNotEmpty((CharSequence)uploadConfig.getCallback())) {
            info.setCallback(this.getCallbackBody(uploadConfig.getCallbackBody(), StringTools.ternary((String)uploadConfig.getCdnHost(), (String)host), fileId, path, uploadConfig.getData(), clientFileName));
        }
        return info;
    }

    private String getFileId(String identity, String clientFileName, UploadConfig tokenConfig) {
        return String.valueOf(StringTools.ternary((String)tokenConfig.getPrefix())) + IdTools.encode((String)(String.valueOf(identity) + StringTools.RandomString.random((int)10))) + StringTools.ternary((String)tokenConfig.getSuffix());
    }

    private String getCallbackBody(String callbackBody, String host, String fileId, String savePath, String data, String clientFileName) throws UnsupportedEncodingException {
        if (StringTools.isNotEmptyAndBlank((String)host)) {
            callbackBody = String.valueOf(callbackBody) + "&host=" + host;
        }
        callbackBody = String.valueOf(callbackBody) + "&fileId=" + fileId + "&path=" + URLEncoder.encode(savePath, "UTF-8") + "&fileName=" + URLEncoder.encode(clientFileName, "UTF-8");
        callbackBody = String.valueOf(callbackBody) + "&mimeType=${mimeType}&imageInfo.format=${imageInfo.format}&imgHeight=${imageInfo.height}&imgWidth=${imageInfo.width}";
        callbackBody = String.valueOf(callbackBody) + "&data=" + StringTools.ternary((String)data);
        return callbackBody;
    }
}

