package com.jz.oss.jar.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.oss.Tables;
import com.jz.jooq.oss.tables.pojos.OssIdentityConfig;

/**
 * @Title OssIdentityConfigRepository
 * @Package com.jz.oss.jar.repository
 * @author tangjunfeng
 * @date 2018年7月13日 下午3:12:27
 * @version V1.0
 */
@Lazy
@Repository
public class OssIdentityConfigRepository extends OssBaseRepository {

	private static final com.jz.jooq.oss.tables.OssIdentityConfig OIC = Tables.OSS_IDENTITY_CONFIG;

	public List<OssIdentityConfig> findAll() {
		return ossCtx.selectFrom(OIC).fetchInto(OssIdentityConfig.class);
	}

	public OssIdentityConfig getOssIdentity(String identity) {
		List<OssIdentityConfig> configs = ossCtx.selectFrom(OIC).where(OIC.ID.eq(identity))
				.fetchInto(OssIdentityConfig.class);
		return ArrayMapTools.isNotEmpty(configs) ? configs.get(0) : null;
	}
}
