package com.jz.oss.jar.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.oss.Tables;
import com.jz.jooq.oss.tables.pojos.OssVideo;
import com.jz.jooq.oss.tables.records.OssVideoRecord;

@Lazy
@Repository
public class OssVideoRepository extends OssBaseRepository {

	private static final com.jz.jooq.oss.tables.OssVideo VIDEO = Tables.OSS_VIDEO;

	public void refreshVideoInfo(OssVideoRecord video) {
		ossCtx.insertInto(VIDEO).set(video).onDuplicateKeyUpdate().set(video).execute();
	}

	public OssVideo getVideo(String wid) {
		List<OssVideo> videos = ossCtx.selectFrom(VIDEO).where(VIDEO.WID.eq(wid)).fetchInto(OssVideo.class);
		return ArrayMapTools.isNotEmpty(videos) ? videos.get(0) : null;
	}
}
