package com.jz.oss.jar.service;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jooq.oss.tables.pojos.OssVideo;
import com.jz.jooq.oss.tables.records.OssVideoRecord;
import com.jz.oss.jar.repository.OssVideoRepository;

/**
 * @Title VideoService
 * @Package com.jz.oss.jar.service
 * @author tangjunfeng
 * @date 2018年7月19日 上午11:00:32
 * @version V1.0
 */
@Lazy
@Service
public class OssVideoService {
	
	@Autowired
	private OssVideoRepository ossVideoRepository;
	
	public void refreshVideoInfo(OssVideoRecord video) {
		ossVideoRepository.refreshVideoInfo(video);
	}
	
	public OssVideo getVideo(String wid) {
		return ossVideoRepository.getVideo(wid);
	}
}
