/*
 * Decompiled with CFR 0.152.
 */
package com.jz.oss.jar.repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oss.Tables;
import com.jz.jooq.oss.tables.pojos.SmsVerificationCode;
import com.jz.jooq.oss.tables.records.SmsVerificationCodeRecord;
import com.jz.oss.jar.repository.OssBaseRepository;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class SmsVerificationCodeRepository
extends OssBaseRepository {
    private static final com.jz.jooq.oss.tables.SmsVerificationCode SVC = Tables.SMS_VERIFICATION_CODE;

    public void save(SmsVerificationCodeRecord record) {
        this.ossCtx.insertInto((Table)SVC).set((Record)record).execute();
    }

    public SmsVerificationCode getValidCode(String phone, String app, String model, long timeMillis) {
        List codes;
        Condition condition = SmsVerificationCodeRepository.SVC.PHONE.eq((Object)phone).and(SmsVerificationCodeRepository.SVC.EXPIRY.ge((Object)timeMillis)).and(SmsVerificationCodeRepository.SVC.APP.eq((Object)app));
        if (StringTools.isNotEmptyAndBlank((String)model)) {
            condition = condition.and(SmsVerificationCodeRepository.SVC.MODEL.eq((Object)model));
        }
        return ArrayMapTools.isNotEmpty((Collection)(codes = this.ossCtx.selectFrom((Table)SVC).where(new Condition[]{condition}).orderBy(SmsVerificationCodeRepository.SVC.CREATE_TIME.desc()).fetchInto(SmsVerificationCode.class))) ? (SmsVerificationCode)codes.get(0) : null;
    }

    public void updateLastSend(Integer id) {
        this.ossCtx.update((Table)SVC).set((Field)SmsVerificationCodeRepository.SVC.LAST_SEND, (Object)System.currentTimeMillis()).where(new Condition[]{SmsVerificationCodeRepository.SVC.ID.eq((Object)id)}).execute();
    }
}

