package com.jz.jar.oa.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.repository.UserWorkflowAuditLogRepository;
import com.jz.jar.oa.repository.UserWorkflowHandlerAttachmentRepository;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditAttachmentLog;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandlerAttachment;

@Lazy
@Service
public class UserWorkflowHandlerAttachmentService {

	@Autowired
	private UserWorkflowHandlerAttachmentRepository userWorkflowHandlerAttachmentRepository;
	@Autowired
	private UserWorkflowAuditLogRepository userWorkflowAuditLogRepository;

	public void addUserWorkflowHandlerAttachment(String uid, Integer step, String uwfid,
			Map<String, String> attachmentName2Path) {
		userWorkflowHandlerAttachmentRepository.addUserWorkflowHandlerAttachment(uid, step, uwfid, attachmentName2Path);
	}

	public void addUserWorkflowAttachmentLog(String logId, Map<String, String> attachmentName2Path) {
		userWorkflowAuditLogRepository.addUserWorkflowAttachmentLog(logId, attachmentName2Path);
	}

	public List<UserWorkflowHandlerAttachment> mutiGetAttachments(String uwfid) {
		return userWorkflowHandlerAttachmentRepository.mutiGetAttachments(uwfid);
	}

	public void cleanAttachments(String uid, String uwfid, Integer step) {
		userWorkflowHandlerAttachmentRepository.cleanAttachments(uid, uwfid, step);
	}

	public void cleanAttachmentsForUwfid(String uwfid) {
		userWorkflowHandlerAttachmentRepository.cleanAttachmentsForUwfid(uwfid);
	}

	public List<UserWorkflowAuditAttachmentLog> mutiGetAttachmentsLog(Set<String> logIds) {
		return userWorkflowAuditLogRepository.mutiGetAttachmentsLog(logIds);
	}
}
