package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OACompanyRepository;
import com.jz.jooq.oa.tables.pojos.Company;

@Lazy
@Service
public class OACompanyService {

	@Autowired
	private OACompanyRepository companyRepository;

	public List<Company> getAllCompany() {
		return companyRepository.getAllCompany();
	}

	public Map<String, Company> multiGetSimpleCompanies(Collection<String> companyIds) {
		List<Company> list = companyRepository.multiGetSimpleCompanies(companyIds);
		if (ArrayMapTools.isEmpty(list))
			return Maps.newHashMap();
		return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
	}

	public Company getCompany(String companyId) {
		return companyRepository.getCompany(companyId);
	}

}
