package com.jz.jar.oa.repository;

import java.math.BigDecimal;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.records.UserVacationLeftRecord;

@Lazy
@Repository
public class UserVacationLeftRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserVacationLeft L = Tables.USER_VACATION_LEFT;

	public void updateVacationLeft(String uid, double fixedAnnualVacation, double compensatedLeave) {
		UserVacationLeftRecord record = new UserVacationLeftRecord();
		record.setUid(uid);
		record.setFixedAnnualVacation(new BigDecimal(fixedAnnualVacation));
		record.setCompensatedLeave(new BigDecimal(compensatedLeave));
		record.setLastUpdated(System.currentTimeMillis());
		oaCtx.insertInto(L).set(record).onDuplicateKeyUpdate().set(record).execute();

	}

}
