package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Position;

@Lazy
@Repository
public class OAPositionRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Position P = Tables.POSITION;

	public List<Position> getAllPosition() {
		return oaCtx.selectFrom(P).where(P.ENABLE.eq(1)).fetchInto(Position.class);
	}

	public List<Position> mutiGetPositions(Collection<String> positionIds) {
		return oaCtx.selectFrom(P).where(P.ID.in(positionIds)).fetchInto(Position.class);
	}

	public Position getPosition(String positionId) {
		return oaCtx.selectFrom(P).where(P.ID.eq(positionId)).fetchAnyInto(Position.class);
	}

}
