package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Company;

@Lazy
@Repository
public class OACompanyRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Company C = Tables.COMPANY;

	public List<Company> getAllCompany() {
		return oaCtx.selectFrom(C).where(C.ENABLE.eq(1)).fetchInto(Company.class);
	}

	public List<Company> multiGetSimpleCompanies(Collection<String> companyIds) {
		return oaCtx.select(C.ID, C.NAME).from(C).where(C.ID.in(companyIds)).fetchInto(Company.class);
	}

	public Company getCompany(String companyId) {
		return oaCtx.selectFrom(C).where(C.ID.eq(companyId)).fetchAnyInto(Company.class);
	}

}
