package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWelfare;
import com.jz.jooq.oa.tables.records.UserWelfareRecord;

@Lazy
@Repository
public class UserWelfareRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWelfare W = Tables.USER_WELFARE;

	public void updateUserWelfare(String fuid, List<UserWelfareRecord> welfareRecords) {
		oaCtx.deleteFrom(W).where(W.UID.eq(fuid)).execute();
		oaCtx.batchInsert(welfareRecords).execute();
	}

	public List<UserWelfare> getUserWelfares(String fuid) {
		return oaCtx.selectFrom(W).where(W.UID.eq(fuid)).orderBy(W.IDX.desc()).fetchInto(UserWelfare.class);
	}

	public List<UserWelfare> mutiGetUserWelfares(Collection<String> fuids) {
		return oaCtx.selectFrom(W).where(W.UID.in(fuids)).orderBy(W.UID.asc(), W.IDX.desc())
				.fetchInto(UserWelfare.class);
	}

}
