package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserPositionHistory;
import com.jz.jooq.oa.tables.records.UserPositionHistoryRecord;

@Lazy
@Repository
public class UserPositionHistoryRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserPositionHistory P = Tables.USER_POSITION_HISTORY;

	public void updateUserPositionHistory(String fuid, List<UserPositionHistoryRecord> positionRecords) {
		oaCtx.deleteFrom(P).where(P.UID.eq(fuid)).execute();
		oaCtx.batchInsert(positionRecords).execute();
	}

	public List<UserPositionHistory> getUserPositionHistorys(String fuid) {
		return oaCtx.selectFrom(P).where(P.UID.eq(fuid)).orderBy(P.IDX.desc()).fetchInto(UserPositionHistory.class);
	}

}
