package com.jz.jar.oa.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.oa.repository.OAPositionRepository;
import com.jz.jar.oa.wrapper.PositionWrapper;
import com.jz.jooq.oa.tables.pojos.Position;

@Lazy
@Service
public class OAPositionService {

	@Autowired
	private OAPositionRepository positionRepository;

	public Map<String, PositionWrapper> mutiGetPositionMap(Collection<String> positionIds) {
		List<Position> list = positionRepository.mutiGetPositions(positionIds);
		return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> PositionWrapper.of(it)));
	}

	public PositionWrapper getPositionWrapper(String positionId) {
		Position p = positionRepository.getPosition(positionId);
		return p != null ? PositionWrapper.of(p) : null;
	}

}
