/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserWorkflowHandler;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;
import com.jz.jooq.oa.tables.records.UserWorkflowInfoRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.SortField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserWorkflowInfoRepository
extends OABaseRepository {
    private static final com.jz.jooq.oa.tables.UserWorkflowInfo UWFI = Tables.USER_WORKFLOW_INFO;
    private static final UserWorkflowHandler H = Tables.USER_WORKFLOW_HANDLER;

    public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId, String workAddrId, String title, String reason, String handler, Integer nextStep, String remarks, UserWorkflow workflowStatus) {
        long timeMillis = System.currentTimeMillis();
        UserWorkflowInfoRecord workflowInfoRecord = new UserWorkflowInfoRecord();
        workflowInfoRecord.setId(identify);
        workflowInfoRecord.setUid(uid);
        workflowInfoRecord.setWfid(wfid);
        workflowInfoRecord.setCompanyId(companyId);
        workflowInfoRecord.setWorkAddrId(workAddrId);
        workflowInfoRecord.setTitle(title);
        workflowInfoRecord.setReason(reason);
        workflowInfoRecord.setHandler(handler);
        workflowInfoRecord.setNextStep(nextStep);
        workflowInfoRecord.setStatus(Integer.valueOf(workflowStatus.getCode()));
        workflowInfoRecord.setResult(null);
        workflowInfoRecord.setRemarks(remarks);
        workflowInfoRecord.setCreateTime(Long.valueOf(timeMillis));
        workflowInfoRecord.setLastUpdate(Long.valueOf(timeMillis));
        this.oaCtx.insertInto((Table)UWFI).set((Record)workflowInfoRecord).onDuplicateKeyUpdate().set((Record)workflowInfoRecord).execute();
    }

    public Condition getWhereCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, String companyId, Collection<String> nickUwfids, Integer flowCode) {
        Condition condition = UserWorkflowInfoRepository.UWFI.ID.in(uwfids);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (flowCode != null) {
            condition = flowCode == 99 ? condition.and(UserWorkflowInfoRepository.UWFI.STATUS.in((Object[])new Integer[]{UserWorkflow.INFO_ING.getCode(), UserWorkflow.INFO_FINISHED.getCode()})) : condition.and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)flowCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)nickname) && ArrayMapTools.isNotEmpty(nickUwfids)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.ID.in(nickUwfids));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.COMPANY_ID.eq((Object)companyId));
        }
        return condition;
    }

    public int cntWorkflows(List<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, String companyId, Collection<String> nickUwfids, Integer flowCode) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getWhereCondition(uwfids, keyword, startTime, endTime, nickname, companyId, nickUwfids, flowCode));
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, String companyId, Collection<String> nickUwfids, int start, int size, Integer flowCode, String uid, int code) {
        com.jz.jooq.oa.tables.UserWorkflowInfo table = UWFI;
        Condition condition = this.getWhereCondition(uwfids, keyword, startTime, endTime, nickname, companyId, nickUwfids, flowCode);
        SortField sf = UserWorkflowInfoRepository.UWFI.CREATE_TIME.desc();
        if (code == 3 && StringUtils.isNotEmpty((CharSequence)uid)) {
            table = UWFI.join((TableLike)H).on(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Field)UserWorkflowInfoRepository.H.UWFID)});
            condition = condition.and(UserWorkflowInfoRepository.H.UID.eq((Object)uid).and(UserWorkflowInfoRepository.H.RESULT.isNotNull()));
            sf = UserWorkflowInfoRepository.H.LAST_UPDATE.desc();
        }
        return this.oaCtx.select((SelectField[])UWFI.fields()).from((TableLike)table).where(new Condition[]{condition}).groupBy(new GroupField[]{UserWorkflowInfoRepository.UWFI.ID}).orderBy(sf).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }

    public UserWorkflowInfo getUserWorkflowInfo(String id) {
        return (UserWorkflowInfo)this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)id)}).fetchAnyInto(UserWorkflowInfo.class);
    }

    public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
        UpdateSetMoreStep moreStep = this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.HANDLER, (Object)handler).set((Field)UserWorkflowInfoRepository.UWFI.NEXT_STEP, (Object)step).set((Field)UserWorkflowInfoRepository.UWFI.LAST_UPDATE, (Object)System.currentTimeMillis());
        if (null != status) {
            moreStep = moreStep.set((Field)UserWorkflowInfoRepository.UWFI.STATUS, (Object)status.getCode());
        }
        if (null != result) {
            moreStep = moreStep.set((Field)UserWorkflowInfoRepository.UWFI.RESULT, (Object)result.getCode());
        }
        moreStep.where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)id)}).execute();
    }

    public Map<String, Integer> getStatusMap(String uid) {
        List maps = this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.STATUS.as("status"), (SelectField)DSL.count().as("cnt")).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid)}).groupBy(new GroupField[]{UserWorkflowInfoRepository.UWFI.STATUS}).fetchMaps();
        HashMap rsMap = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty((Collection)maps)) {
            Integer all = 0;
            for (Map it : maps) {
                if (MapUtils.getString((Map)it, (Object)"status").equals("1")) {
                    all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
                    rsMap.put("going", MapUtils.getInteger((Map)it, (Object)"cnt"));
                    continue;
                }
                if (MapUtils.getString((Map)it, (Object)"status").equals("2")) {
                    all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
                    rsMap.put("end", MapUtils.getInteger((Map)it, (Object)"cnt"));
                    continue;
                }
                all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
            }
            rsMap.put("all", all);
        }
        return rsMap;
    }

    public String getLatestPassedWorkflowId(String uid, String wfid) {
        return (String)this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)wfid)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).orderBy(UserWorkflowInfoRepository.UWFI.LAST_UPDATE.desc()).fetchAnyInto(String.class);
    }

    public List<String> mutiGetUserWorkflowId(String uid, String wfid, String keyword) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)wfid)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode())).and(StringUtils.isEmpty((CharSequence)keyword) ? DSL.trueCondition() : UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%"))}).limit(50).fetchInto(String.class);
    }

    public List<String> mutiGetUserWorkflowIds(String uid, Collection<String> wfids, String keyword) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.in(wfids)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode())).and(StringUtils.isEmpty((CharSequence)keyword) ? DSL.trueCondition() : UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%"))}).limit(50).fetchInto(String.class);
    }

    public List<String> mutiGetAllLogisticsFWorkflowIds(String uid, Collection<String> wfids, String keyword) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.WFID.in(wfids).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode())).and(StringUtils.isEmpty((CharSequence)keyword) ? DSL.trueCondition() : UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%"))}).limit(50).fetchInto(String.class);
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflows(String uid, String name) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)name)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).fetchInto(UserWorkflowInfo.class);
    }

    public List<String> getUserLeaveWorkflowInProgress(String uid, String workflowKey) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)workflowKey).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_ING.getCode())))}).fetchInto(String.class);
    }

    public void updateBackModifyToNormal(String uwfid, String remarks) {
        Object _null = null;
        this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.RESULT, _null).set((Field)UserWorkflowInfoRepository.UWFI.REMARKS, (Object)remarks).set((Field)UserWorkflowInfoRepository.UWFI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)uwfid)}).execute();
    }

    public List<String> mutiGetAllAssetReportIds(String uid, String name) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.WFID.eq((Object)name).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).fetchInto(String.class);
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfids)}).fetchInto(UserWorkflowInfo.class);
    }

    public List<String> getUwfidsInProgressNeedUid(Collection<String> uwfidsNeedUid) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfidsNeedUid).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_ING.getCode()))}).fetchInto(String.class);
    }

    public void updateHandler(Collection<String> uwfids, String uid, String taker) {
        this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.HANDLER, (Object)taker).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfids).and(UserWorkflowInfoRepository.UWFI.HANDLER.eq((Object)uid))}).execute();
    }

    public List<String> getUwfidsByWfid(Collection<String> wfids) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{this.purchaseCondition(wfids)}).fetchInto(String.class);
    }

    public List<String> filterPurchaseUwfids(String uwfid, Collection<String> wfids) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{this.purchaseCondition(wfids).and(UserWorkflowInfoRepository.UWFI.ID.like("%" + uwfid + "%"))}).fetchInto(String.class);
    }

    private Condition purchaseCondition(Collection<String> wfids) {
        Condition condition = UserWorkflowInfoRepository.UWFI.WFID.in(wfids);
        condition = condition.and(UserWorkflowInfoRepository.UWFI.STATUS.ne((Object)UserWorkflow.INFO_WAIT.getCode()).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()).and(UserWorkflowInfoRepository.UWFI.RESULT.isNotNull())));
        return condition;
    }

    public int cntCreatedByMe(String uid, String keyword, Long startTime, Long endTime, Collection<String> nicknameUwfids, String companyId, Integer flowType) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getCreatedByMeConditon(uid, keyword, startTime, endTime, nicknameUwfids, companyId, flowType));
    }

    private Condition getCreatedByMeConditon(String uid, String keyword, Long startTime, Long endTime, Collection<String> nicknameUwfids, String companyId, Integer flowCode) {
        Condition condition = UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (flowCode != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)flowCode));
        }
        if (nicknameUwfids != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.ID.in(nicknameUwfids));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.COMPANY_ID.eq((Object)companyId));
        }
        return condition;
    }

    public List<UserWorkflowInfo> mutiGetCreatedByMe(String uid, String keyword, Long startTime, Long endTime, Collection<String> nicknameUwfids, String companyId, Integer flowType, int start, int size) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{this.getCreatedByMeConditon(uid, keyword, startTime, endTime, nicknameUwfids, companyId, flowType)}).orderBy(UserWorkflowInfoRepository.UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }

    public int cntWaitedForMe(String keyword, Long startTime, Long endTime, String companyId, Collection<String> uwfids) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getWaitedForMeCondition(keyword, startTime, endTime, uwfids, companyId));
    }

    private Condition getWaitedForMeCondition(String keyword, Long startTime, Long endTime, Collection<String> uwfids, String companyId) {
        Condition condition = UserWorkflowInfoRepository.UWFI.ID.in(uwfids);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.COMPANY_ID.eq((Object)companyId));
        }
        return condition;
    }

    public List<UserWorkflowInfo> mutiGetWaitedForMe(String keyword, Long startTime, Long endTime, String companyId, Collection<String> uwfids, int start, int size) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{this.getWaitedForMeCondition(keyword, startTime, endTime, uwfids, companyId)}).orderBy(UserWorkflowInfoRepository.UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }

    public Condition getProcessedByMeCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId) {
        Condition condition = UserWorkflowInfoRepository.UWFI.ID.in(uwfids);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.COMPANY_ID.eq((Object)companyId));
        }
        return condition;
    }

    public int cntProcessedByMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getProcessedByMeCondition(uwfids, keyword, startTime, endTime, companyId));
    }

    public List<UserWorkflowInfo> mutiGetProcessedByMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId, int start, int size) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{this.getProcessedByMeCondition(uwfids, keyword, startTime, endTime, companyId)}).orderBy(UserWorkflowInfoRepository.UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }

    public int cntCopiedToMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getCopiedToMeCondition(uwfids, keyword, startTime, endTime, companyId));
    }

    private Condition getCopiedToMeCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId) {
        Condition condition = UserWorkflowInfoRepository.UWFI.ID.in(uwfids);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.COMPANY_ID.eq((Object)companyId));
        }
        return condition;
    }

    public List<UserWorkflowInfo> mutiGetCopiedToMe(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String companyId, int start, int size) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{this.getCopiedToMeCondition(uwfids, keyword, startTime, endTime, companyId)}).orderBy(UserWorkflowInfoRepository.UWFI.CREATE_TIME.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }
}

