package com.jz.jar.oa.wrapper;

import com.jz.jooq.oa.tables.pojos.Company;

public class CompanyWrapper {

	private String id;
	private String name;
	private String license;
	private OAUserWrapper accounter;
	private OAUserWrapper cashier;
	private OAUserWrapper law;
	private Long lastUpdated;

	private Integer staffNum;

	public static CompanyWrapper of(Company company) {
		return new CompanyWrapper().setId(company.getId()).setName(company.getName()).setLicense(company.getLicense())
				.setLastUpdated(company.getLastUpdated());
	}

	public static CompanyWrapper ofSimple(Company company) {
		return new CompanyWrapper().setId(company.getId()).setName(company.getName());
	}

	public String getId() {
		return id;
	}

	public CompanyWrapper setId(String id) {
		this.id = id;
		return this;
	}

	public String getName() {
		return name;
	}

	public CompanyWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getLicense() {
		return license;
	}

	public CompanyWrapper setLicense(String license) {
		this.license = license;
		return this;
	}

	public OAUserWrapper getAccounter() {
		return accounter;
	}

	public CompanyWrapper setAccounter(OAUserWrapper accounter) {
		this.accounter = accounter;
		return this;
	}

	public OAUserWrapper getCashier() {
		return cashier;
	}

	public CompanyWrapper setCashier(OAUserWrapper cashier) {
		this.cashier = cashier;
		return this;
	}

	public OAUserWrapper getLaw() {
		return law;
	}

	public CompanyWrapper setLaw(OAUserWrapper law) {
		this.law = law;
		return this;
	}

	public Long getLastUpdated() {
		return lastUpdated;
	}

	public CompanyWrapper setLastUpdated(Long lastUpdated) {
		this.lastUpdated = lastUpdated;
		return this;
	}

	public Integer getStaffNum() {
		return staffNum;
	}

	public CompanyWrapper setStaffNum(Integer staffNum) {
		this.staffNum = staffNum;
		return this;
	}

}
