package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.WorkAddress;

@Lazy
@Repository
public class OAWorkAddressRepository extends OABaseRepository {
	private static final com.jz.jooq.oa.tables.WorkAddress WD = Tables.WORK_ADDRESS;

	public List<WorkAddress> getAllWorkAddress() {
		return oaCtx.selectFrom(WD).where(WD.ENABLE.eq(1)).fetchInto(WorkAddress.class);
	}

	public WorkAddress getWorkAddress(String workAddrId) {
		return oaCtx.selectFrom(WD).where(WD.ID.eq(workAddrId)).fetchAnyInto(WorkAddress.class);
	}

}
