/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jar.oa.repository.UserPositionHistoryRepository;
import com.jz.jar.oa.repository.UserRewardsAndPunishmentRepository;
import com.jz.jar.oa.repository.UserSkillRepository;
import com.jz.jar.oa.repository.UserTrainingRepository;
import com.jz.jar.oa.repository.UserWelfareRepository;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserPositionHistory;
import com.jz.jooq.oa.tables.pojos.UserRewardsAndPunishment;
import com.jz.jooq.oa.tables.pojos.UserSkill;
import com.jz.jooq.oa.tables.pojos.UserTraining;
import com.jz.jooq.oa.tables.pojos.UserWelfare;
import com.jz.jooq.oa.tables.records.UserPositionHistoryRecord;
import com.jz.jooq.oa.tables.records.UserRecord;
import com.jz.jooq.oa.tables.records.UserRewardsAndPunishmentRecord;
import com.jz.jooq.oa.tables.records.UserSkillRecord;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;
import com.jz.jooq.oa.tables.records.UserWelfareRecord;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OAUserService {
    @Autowired
    private OAUserRepository userRepository;
    @Autowired
    private UserSkillRepository userSkillRepository;
    @Autowired
    private UserWelfareRepository userWelfareRepository;
    @Autowired
    private UserTrainingRepository userTrainingRepository;
    @Autowired
    private UserRewardsAndPunishmentRepository userRewardsAndPunishmentRepository;
    @Autowired
    private UserPositionHistoryRepository userPositionHistoryRepository;

    public void updateUserStatus(String uid, int status) {
        Preconditions.checkArgument((status == 1 || status == 2 ? 1 : 0) != 0, (Object)"status\u53c2\u6570\u9519\u8bef");
        this.userRepository.updateUserStatus(uid, status);
    }

    public User getUser(String uid) {
        return this.userRepository.getUser(uid);
    }

    public User getUserInfo(String uid) {
        return this.userRepository.getUserInfo(uid);
    }

    public Map<String, User> mutiGetUserMap(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> mutGetAllUsers(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetAllUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
        return this.userRepository.getStaffNumByDeptIds(deptIds);
    }

    public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword) {
        return this.userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword);
    }

    public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword, int start, int size) {
        return this.userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword, start, size);
    }

    public List<String> filterUids(String keyword) {
        return this.userRepository.filterUids(keyword);
    }

    public void createUser(UserRecord record) {
        this.userRepository.createUser(record);
    }

    public void updateUser(String fuid, String chineseName, String englishName, String phone, int status, String cardType, String cardBak, String nationality, String country, String fertility, String residenceType, String residenceAddress, String contactAddress, String landline, String emergencyContact, String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate) {
        this.userRepository.updateUser(fuid, chineseName, englishName, phone, status, cardType, cardBak, nationality, country, fertility, residenceType, residenceAddress, contactAddress, landline, emergencyContact, emergencyPhone, insurance, childFree, trainAgreement, joinDate);
    }

    public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature, String deptId, String positionId, String superiorId, String relations, String workAddrId, String companyId, String laborUnion, String costCenter) {
        this.userRepository.updateUserPositionInfo(fuid, joinChannel, referrer, officialJoinDate, contractStart, contractEnd, contractType, contractNature, deptId, positionId, superiorId, relations, workAddrId, companyId, laborUnion, costCenter);
    }

    public void updateUserSkills(String fuid, List<UserSkillRecord> skillRecords) {
        this.userSkillRepository.updateUserSkills(fuid, skillRecords);
    }

    public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
        this.userRepository.updateBackgroundSurvey(fuid, backgroundSurvey);
    }

    public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund, String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays, String certificate, Integer oldLeaveDays, String leaveAdjustDate) {
        this.userRepository.updateUserAccountInfo(fuid, bankAccount, bank, bankArea, fund, socialSecurityType, socialSecurityArea, tax, annualLeaveDays, certificate, oldLeaveDays, leaveAdjustDate);
    }

    public void updateUserWelfare(String fuid, List<UserWelfareRecord> welfareRecords) {
        this.userWelfareRepository.updateUserWelfare(fuid, welfareRecords);
    }

    public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
        this.userTrainingRepository.updateUserTraining(fuid, trainingRecords);
    }

    public void updateUserRewardsAndPunishment(String fuid, List<UserRewardsAndPunishmentRecord> rpRecords) {
        this.userRewardsAndPunishmentRepository.updateUserRewardsAndPunishment(fuid, rpRecords);
    }

    public void updateUserPositionHistory(String fuid, List<UserPositionHistoryRecord> positionRecords) {
        this.userPositionHistoryRepository.updateUserPositionHistory(fuid, positionRecords);
    }

    public List<UserSkill> getUserSkills(String fuid) {
        return this.userSkillRepository.getUserSkills(fuid);
    }

    public List<UserWelfare> getUserWelfares(String fuid) {
        return this.userWelfareRepository.getUserWelfares(fuid);
    }

    public List<UserTraining> getUserTrainings(String fuid) {
        return this.userTrainingRepository.getUserTrainings(fuid);
    }

    public List<UserRewardsAndPunishment> getUserRewardsAndPunishments(String fuid) {
        return this.userRewardsAndPunishmentRepository.getUserRewardsAndPunishments(fuid);
    }

    public List<UserPositionHistory> getUserPositionHistorys(String fuid) {
        return this.userPositionHistoryRepository.getUserPositionHistorys(fuid);
    }

    public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature) {
        this.userRepository.backInOffice(fuid, joinDate, officialJoinDate, contractStart, contractEnd, contractType, contractNature);
    }

    public void createUserTraining(String fuid, String name, String type, Long startTime, Long endTime, int status, String remark, String certificate) {
        List<UserTraining> userTrainings = this.userTrainingRepository.getUserTrainings(fuid);
        this.userTrainingRepository.createUserTraining(fuid, userTrainings.size() + 1, name, type, startTime, endTime, status, remark, certificate);
    }

    public Integer getOldLeaveDays(String fuid) {
        return this.userRepository.getOldLeaveDays(fuid);
    }

    public List<String> filterUidsByConditionsLimit(String uid, String companyId, String keyword, int start, int size) {
        return this.userRepository.filterUidsByConditionsLimit(uid, companyId, keyword, start, size);
    }
}

