/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.records.UserRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class OAUserRepository
extends OABaseRepository {
    private static final com.jz.jooq.oa.tables.User U = Tables.USER;

    public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId, String workAddrId, String deptId, String positionId, String superiorId, String joinDate, String relations, Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate, int status) {
        this.oaCtx.insertInto((Table)U).set((Field)OAUserRepository.U.UID, (Object)uid).set((Field)OAUserRepository.U.CHINESE_NAME, (Object)chineseName).set((Field)OAUserRepository.U.ENGLISH_NAME, (Object)englishName).set((Field)OAUserRepository.U.PHONE, (Object)phone).set((Field)OAUserRepository.U.COMPANY_ID, (Object)companyId).set((Field)OAUserRepository.U.WORK_ADDR_ID, (Object)workAddrId).set((Field)OAUserRepository.U.DEPT_ID, (Object)deptId).set((Field)OAUserRepository.U.POSITION_ID, (Object)positionId).set((Field)OAUserRepository.U.SUPERIOR_ID, (Object)superiorId).set((Field)OAUserRepository.U.JOIN_DATE, (Object)joinDate).set((Field)OAUserRepository.U.RELATIONS, (Object)relations).set((Field)OAUserRepository.U.INSURANCE, (Object)insurance).set((Field)OAUserRepository.U.CHILD_FREE, (Object)childFree).set((Field)OAUserRepository.U.TRAIN_AGREEMENT, (Object)trainAgreement).set((Field)OAUserRepository.U.ANNUAL_LEAVE_DAYS, (Object)annualLeaveDays).set((Field)OAUserRepository.U.CERTIFICATE, (Object)certificate).set((Field)OAUserRepository.U.STATUS, (Object)status).onDuplicateKeyUpdate().set((Field)OAUserRepository.U.CHINESE_NAME, (Object)chineseName).set((Field)OAUserRepository.U.ENGLISH_NAME, (Object)englishName).set((Field)OAUserRepository.U.PHONE, (Object)phone).set((Field)OAUserRepository.U.COMPANY_ID, (Object)companyId).set((Field)OAUserRepository.U.WORK_ADDR_ID, (Object)workAddrId).set((Field)OAUserRepository.U.DEPT_ID, (Object)deptId).set((Field)OAUserRepository.U.POSITION_ID, (Object)positionId).set((Field)OAUserRepository.U.SUPERIOR_ID, (Object)superiorId).set((Field)OAUserRepository.U.JOIN_DATE, (Object)joinDate).set((Field)OAUserRepository.U.RELATIONS, (Object)relations).set((Field)OAUserRepository.U.INSURANCE, (Object)insurance).set((Field)OAUserRepository.U.CHILD_FREE, (Object)childFree).set((Field)OAUserRepository.U.TRAIN_AGREEMENT, (Object)trainAgreement).set((Field)OAUserRepository.U.ANNUAL_LEAVE_DAYS, (Object)annualLeaveDays).set((Field)OAUserRepository.U.CERTIFICATE, (Object)certificate).set((Field)OAUserRepository.U.STATUS, (Object)status).execute();
    }

    public void updateUserStatus(String uid, int status) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.STATUS, (Object)status).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid)}).execute();
    }

    public User getUser(String uid) {
        return (User)this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchAnyInto(User.class);
    }

    public User getUserInfo(String uid) {
        return (User)this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid)}).fetchAnyInto(User.class);
    }

    public List<User> mutGetUsers(Collection<String> uids) {
        return this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.UID.in(uids).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchInto(User.class);
    }

    public List<User> mutGetAllUsers(Collection<String> uids) {
        return this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.UID.in(uids)}).fetchInto(User.class);
    }

    public List<User> multiGetSimpleUser(Collection<String> uids) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.in(uids).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchInto(User.class);
    }

    public List<User> multiGetAllSimpleUser(Collection<String> uids) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.in(uids)}).fetchInto(User.class);
    }

    public User getSimpleUser(String uid) {
        return (User)this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.SUPERIOR_ID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME, (SelectField)OAUserRepository.U.POSITION_ID, (SelectField)OAUserRepository.U.COMPANY_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchAnyInto(User.class);
    }

    public User getAllSimpleUser(String uid) {
        return (User)this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid)}).fetchAnyInto(User.class);
    }

    public boolean isIncumbency(String uid) {
        return this.oaCtx.fetchExists((Table)U, OAUserRepository.U.UID.eq((Object)uid).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public int cntDeptUser(String deptId) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.DEPT_ID.eq((Object)deptId).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public int cntPositionUser(String id) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.POSITION_ID.eq((Object)id).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public Map<String, Integer> getStaffNumByCompanyIds(Collection<String> companyIds) {
        List list = this.oaCtx.select((SelectField)OAUserRepository.U.COMPANY_ID.as("companyId"), (SelectField)DSL.count().as("cnt")).from((TableLike)U).where(new Condition[]{OAUserRepository.U.COMPANY_ID.in(companyIds).and(OAUserRepository.U.STATUS.eq((Object)1))}).groupBy(new GroupField[]{OAUserRepository.U.COMPANY_ID}).fetchMaps();
        HashMap rsMap = Maps.newHashMap();
        for (Map map : list) {
            rsMap.put(MapUtils.getString((Map)map, (Object)"companyId"), MapUtils.getIntValue((Map)map, (Object)"cnt"));
        }
        return rsMap;
    }

    public int cntCompanyUser(String id) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.COMPANY_ID.eq((Object)id).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public Map<String, Integer> getStaffNumByWorkAddressIds(Collection<String> workAddressIds) {
        List list = this.oaCtx.select((SelectField)OAUserRepository.U.WORK_ADDR_ID.as("workAddressId"), (SelectField)DSL.count().as("cnt")).from((TableLike)U).where(new Condition[]{OAUserRepository.U.WORK_ADDR_ID.in(workAddressIds).and(OAUserRepository.U.STATUS.eq((Object)1))}).groupBy(new GroupField[]{OAUserRepository.U.WORK_ADDR_ID}).fetchMaps();
        HashMap rsMap = Maps.newHashMap();
        for (Map map : list) {
            rsMap.put(MapUtils.getString((Map)map, (Object)"workAddressId"), MapUtils.getIntValue((Map)map, (Object)"cnt"));
        }
        return rsMap;
    }

    public int cntWorkAddressUser(String id) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.WORK_ADDR_ID.eq((Object)id).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public int cntAllWorkAddressUser(String id) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.WORK_ADDR_ID.eq((Object)id));
    }

    public Map<String, Integer> getStaffNumByDeptIds(Collection<String> deptIds) {
        List list = this.oaCtx.select((SelectField)OAUserRepository.U.DEPT_ID.as("deptId"), (SelectField)DSL.count().as("cnt")).from((TableLike)U).where(new Condition[]{OAUserRepository.U.DEPT_ID.in(deptIds).and(OAUserRepository.U.STATUS.eq((Object)1))}).groupBy(new GroupField[]{OAUserRepository.U.DEPT_ID}).fetchMaps();
        HashMap rsMap = Maps.newHashMap();
        for (Map map : list) {
            rsMap.put(MapUtils.getString((Map)map, (Object)"deptId"), MapUtils.getIntValue((Map)map, (Object)"cnt"));
        }
        return rsMap;
    }

    public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
        return this.oaCtx.selectFrom((Table)U).where(new Condition[]{this.searchWhereCondition(companyId, keyword)}).and(OAUserRepository.U.STATUS.eq((Object)1)).orderBy(OAUserRepository.U.JOIN_DATE.asc(), OAUserRepository.U.UID.desc()).limit(start, size).fetchInto(User.class);
    }

    private Condition searchWhereCondition(String companyId, String keyword) {
        Condition condition = DSL.trueCondition();
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(OAUserRepository.U.COMPANY_ID.eq((Object)companyId));
        }
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(OAUserRepository.U.CHINESE_NAME.like("%" + keyword + "%").or(OAUserRepository.U.ENGLISH_NAME.like("%" + keyword + "%")));
        }
        return condition;
    }

    public User getUserByPosition(String positionId) {
        return (User)this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.POSITION_ID.eq((Object)positionId).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchAnyInto(User.class);
    }

    public List<String> getDeptIdsForCompany(String companyId) {
        return this.oaCtx.selectDistinct((SelectField)OAUserRepository.U.DEPT_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.COMPANY_ID.eq((Object)companyId).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public List<User> getUsersForDepartment(String companyId, String deptId) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.COMPANY_ID.eq((Object)companyId).and(OAUserRepository.U.STATUS.eq((Object)1)).and(OAUserRepository.U.DEPT_ID.eq((Object)deptId))}).fetchInto(User.class);
    }

    public User getUserByPhone(String phone) {
        return (User)this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.PHONE.eq((Object)phone).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchAnyInto(User.class);
    }

    public String getSuperiorUid(String uid) {
        return (String)this.oaCtx.select((SelectField)OAUserRepository.U.SUPERIOR_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchAnyInto(String.class);
    }

    public void updateSuperior(String currentlySuperior, String newSuperior) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.SUPERIOR_ID, (Object)newSuperior).where(new Condition[]{OAUserRepository.U.SUPERIOR_ID.eq((Object)currentlySuperior)}).execute();
    }

    public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.WORK_ADDR_ID.eq((Object)workAddrId)}).orderBy(OAUserRepository.U.JOIN_DATE.desc(), OAUserRepository.U.UID.desc()).limit(start, size).fetchInto(User.class);
    }

    private Condition getConditions(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
        Condition condition = DSL.trueCondition();
        if (ArrayMapTools.isNotEmpty(filterWorkAddrIds) && ArrayMapTools.isNotEmpty(filterCompanyIds)) {
            condition = condition.and(OAUserRepository.U.WORK_ADDR_ID.in(filterWorkAddrIds)).and(OAUserRepository.U.COMPANY_ID.in(filterCompanyIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)departmentId)) {
            condition = condition.and(OAUserRepository.U.DEPT_ID.eq((Object)departmentId));
        }
        if (StringUtils.isNotEmpty((CharSequence)companyId)) {
            condition = condition.and(OAUserRepository.U.COMPANY_ID.eq((Object)companyId));
        }
        if (StringUtils.isNotEmpty((CharSequence)workAddrId)) {
            condition = condition.and(OAUserRepository.U.WORK_ADDR_ID.eq((Object)workAddrId));
        }
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(OAUserRepository.U.CHINESE_NAME.like("%" + keyword + "%").or(OAUserRepository.U.ENGLISH_NAME.like("%" + keyword + "%")).or(OAUserRepository.U.PHONE.like("%" + keyword + "%")));
        }
        return condition;
    }

    public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds, int start, int size) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds)}).orderBy(OAUserRepository.U.JOIN_DATE.asc(), OAUserRepository.U.UID.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<String> filterIncumbentUidsByConditionsLimit(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds, int start, int size) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds).and(OAUserRepository.U.STATUS.eq((Object)1))}).orderBy(OAUserRepository.U.JOIN_DATE.asc(), OAUserRepository.U.UID.desc()).limit(start, size).fetchInto(String.class);
    }

    public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
        return this.oaCtx.fetchCount((Table)U, this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds));
    }

    public int cntIncumbentUsersByConditions(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
        return this.oaCtx.fetchCount((Table)U, this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds).and(OAUserRepository.U.STATUS.eq((Object)1)));
    }

    public int cntUsers(Collection<String> filterUids) {
        return this.oaCtx.fetchCount((Table)U, OAUserRepository.U.UID.in(filterUids));
    }

    public List<String> filterRegularEmployee(String date) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.STATUS.eq((Object)1).and(OAUserRepository.U.JOIN_DATE.ge((Object)date))}).fetchInto(String.class);
    }

    public void addFloatAnnualLeaveDays(Collection<String> filterUids) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.FLOAT_ANNUAL_LEAVE_DAYS, OAUserRepository.U.FLOAT_ANNUAL_LEAVE_DAYS.add((Number)1)).where(new Condition[]{OAUserRepository.U.UID.in(filterUids)}).execute();
    }

    public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword) {
        return this.oaCtx.fetchCount((Table)U, this.getConditions(uid, departmentId, companyId, workAddrId, keyword, Sets.newHashSet(), Sets.newHashSet()).and(OAUserRepository.U.STATUS.eq((Object)status)));
    }

    public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword, int start, int size) {
        return this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.STATUS.eq((Object)status).and(this.getConditions(uid, departmentId, companyId, workAddrId, keyword, Sets.newHashSet(), Sets.newHashSet()))}).orderBy(OAUserRepository.U.JOIN_DATE.desc(), OAUserRepository.U.UID.asc()).limit(start, size).fetchInto(User.class);
    }

    public List<User> getRegularEmployees() {
        return this.oaCtx.selectFrom((Table)U).where(new Condition[]{OAUserRepository.U.STATUS.eq((Object)1)}).fetchInto(User.class);
    }

    public List<User> getHrList(Collection<String> hrs) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.ENGLISH_NAME).from((TableLike)U).where(new Condition[]{OAUserRepository.U.STATUS.eq((Object)1).and(OAUserRepository.U.UID.in(hrs))}).fetchInto(User.class);
    }

    public List<String> findUserIdForWorkAddress(Collection<String> workAddressIds) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.WORK_ADDR_ID.in(workAddressIds).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public List<String> getCompanyForUser(Collection<String> uids) {
        return this.oaCtx.selectDistinct((SelectField)OAUserRepository.U.COMPANY_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.in(uids).and(OAUserRepository.U.STATUS.eq((Object)1))}).fetchInto(String.class);
    }

    public void changeToResignation(String uid, int status, String resignationDate) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.STATUS, (Object)status).set((Field)OAUserRepository.U.RESIGNATION_DATE, (Object)resignationDate).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid)}).execute();
    }

    public List<String> filterUids(String keyword) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{StringUtils.isEmpty((CharSequence)keyword) ? DSL.trueCondition() : OAUserRepository.U.CHINESE_NAME.like("%" + keyword + "%").or(OAUserRepository.U.ENGLISH_NAME.like("%" + keyword + "%"))}).fetchInto(String.class);
    }

    public List<String> getUsersByPosition(String positionId) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.POSITION_ID.eq((Object)positionId)}).fetchInto(String.class);
    }

    public void createUser(UserRecord record) {
        this.oaCtx.insertInto((Table)U).set((Record)record).onDuplicateKeyUpdate().set((Record)record).execute();
    }

    public void updateUser(String fuid, String chineseName, String englishName, String phone, int status, String cardType, String cardBak, String nationality, String country, String fertility, String residenceType, String residenceAddress, String contactAddress, String landline, String emergencyContact, String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.CHINESE_NAME, (Object)chineseName).set((Field)OAUserRepository.U.ENGLISH_NAME, (Object)englishName).set((Field)OAUserRepository.U.PHONE, (Object)phone).set((Field)OAUserRepository.U.STATUS, (Object)status).set((Field)OAUserRepository.U.CARD_TYPE, (Object)cardType).set((Field)OAUserRepository.U.CARD_BAK, (Object)cardBak).set((Field)OAUserRepository.U.NATIONALITY, (Object)nationality).set((Field)OAUserRepository.U.COUNTRY, (Object)country).set((Field)OAUserRepository.U.FERTILITY, (Object)fertility).set((Field)OAUserRepository.U.RESIDENCE_TYPE, (Object)residenceType).set((Field)OAUserRepository.U.RESIDENCE_ADDRESS, (Object)residenceAddress).set((Field)OAUserRepository.U.CONTACT_ADDRESS, (Object)contactAddress).set((Field)OAUserRepository.U.LANDLINE, (Object)landline).set((Field)OAUserRepository.U.EMERGENCY_CONTACT, (Object)emergencyContact).set((Field)OAUserRepository.U.EMERGENCY_PHONE, (Object)emergencyPhone).set((Field)OAUserRepository.U.INSURANCE, (Object)insurance).set((Field)OAUserRepository.U.CHILD_FREE, (Object)childFree).set((Field)OAUserRepository.U.TRAIN_AGREEMENT, (Object)trainAgreement).set((Field)OAUserRepository.U.JOIN_DATE, (Object)joinDate).where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).execute();
    }

    public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature, String deptId, String positionId, String superiorId, String relations, String workAddrId, String companyId, String laborUnion, String costCenter) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.JOIN_CHANNEL, (Object)joinChannel).set((Field)OAUserRepository.U.REFERRER, (Object)referrer).set((Field)OAUserRepository.U.OFFICIAL_JOIN_DATE, (Object)officialJoinDate).set((Field)OAUserRepository.U.CONTRACT_START, (Object)contractStart).set((Field)OAUserRepository.U.CONTRACT_END, (Object)contractEnd).set((Field)OAUserRepository.U.CONTRACT_TYPE, (Object)contractType).set((Field)OAUserRepository.U.CONTRACT_NATURE, (Object)contractNature).set((Field)OAUserRepository.U.DEPT_ID, (Object)deptId).set((Field)OAUserRepository.U.POSITION_ID, (Object)positionId).set((Field)OAUserRepository.U.SUPERIOR_ID, (Object)superiorId).set((Field)OAUserRepository.U.RELATIONS, (Object)relations).set((Field)OAUserRepository.U.WORK_ADDR_ID, (Object)workAddrId).set((Field)OAUserRepository.U.COMPANY_ID, (Object)companyId).set((Field)OAUserRepository.U.LABOR_UNION, (Object)laborUnion).set((Field)OAUserRepository.U.COST_CENTER, (Object)costCenter).where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).execute();
    }

    public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.BACKGROUND_SURVEY, (Object)backgroundSurvey).where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).execute();
    }

    public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund, String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays, String certificate, Integer oldLeaveDays, String leaveAdjustDate) {
        UpdateSetMoreStep moreStep = this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.BANK_ACCOUNT, (Object)bankAccount).set((Field)OAUserRepository.U.BANK, (Object)bank).set((Field)OAUserRepository.U.BANK_AREA, (Object)bankArea).set((Field)OAUserRepository.U.FUND, (Object)fund).set((Field)OAUserRepository.U.SOCIAL_SECURITY_TYPE, (Object)socialSecurityType).set((Field)OAUserRepository.U.SOCIAL_SECURITY_AREA, (Object)socialSecurityArea).set((Field)OAUserRepository.U.TAX, (Object)tax).set((Field)OAUserRepository.U.ANNUAL_LEAVE_DAYS, (Object)annualLeaveDays).set((Field)OAUserRepository.U.CERTIFICATE, (Object)certificate);
        if (StringUtils.isNotEmpty((CharSequence)leaveAdjustDate) && oldLeaveDays != annualLeaveDays) {
            moreStep.set((Field)OAUserRepository.U.OLD_LEAVE_DAYS, (Object)oldLeaveDays).set((Field)OAUserRepository.U.LEAVE_ADJUST_DATE, (Object)leaveAdjustDate);
        }
        moreStep.where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).execute();
    }

    public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature) {
        Object _null = null;
        this.oaCtx.update((Table)U).set((Field)OAUserRepository.U.JOIN_DATE, (Object)joinDate).set((Field)OAUserRepository.U.OFFICIAL_JOIN_DATE, (Object)officialJoinDate).set((Field)OAUserRepository.U.CONTRACT_START, (Object)contractStart).set((Field)OAUserRepository.U.CONTRACT_END, (Object)contractEnd).set((Field)OAUserRepository.U.CONTRACT_TYPE, (Object)contractType).set((Field)OAUserRepository.U.CONTRACT_NATURE, (Object)contractNature).set((Field)OAUserRepository.U.RESIGNATION_DATE, _null).set((Field)OAUserRepository.U.STATUS, (Object)1).where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).execute();
    }

    public List<User> multiGetUserAddr(Collection<String> uids) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID, (SelectField)OAUserRepository.U.CHINESE_NAME, (SelectField)OAUserRepository.U.WORK_ADDR_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.in(uids)}).fetchInto(User.class);
    }

    public List<String> filterSubordinates(Collection<String> subordinates) {
        return this.oaCtx.select((SelectField)OAUserRepository.U.UID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.SUPERIOR_ID.in(subordinates)}).fetchInto(String.class);
    }

    public String getUserWorkAddress(String uid) {
        return (String)this.oaCtx.select((SelectField)OAUserRepository.U.WORK_ADDR_ID).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)uid)}).fetchAnyInto(String.class);
    }

    public Integer getOldLeaveDays(String fuid) {
        return (Integer)this.oaCtx.select((SelectField)OAUserRepository.U.ANNUAL_LEAVE_DAYS).from((TableLike)U).where(new Condition[]{OAUserRepository.U.UID.eq((Object)fuid)}).fetchAnyInto(Integer.class);
    }
}

