package com.jz.jar.oa.repository;

import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandlerAttachment;
import com.jz.jooq.oa.tables.records.UserWorkflowHandlerAttachmentRecord;

@Lazy
@Repository
public class UserWorkflowHandlerAttachmentRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowHandlerAttachment UWHA = Tables.USER_WORKFLOW_HANDLER_ATTACHMENT;

	public void addUserWorkflowHandlerAttachment(String uid, Integer step, String uwfid, Map<String, String> attachmentName2Path) {
		List<UserWorkflowHandlerAttachmentRecord> attachmentRecords = Lists.newArrayList();
		attachmentName2Path.forEach((name, url) -> {
			attachmentRecords.add(new UserWorkflowHandlerAttachmentRecord(null, uwfid, uid, step, name, url));
		});
		oaCtx.batchInsert(attachmentRecords).execute();
	}

	public List<UserWorkflowHandlerAttachment> mutiGetAttachments(String uwfid) {
		return oaCtx.select(UWHA.UID, UWHA.STEP, UWHA.NAME, UWHA.URL).from(UWHA).where(UWHA.UWFID.eq(uwfid))
				.fetchInto(UserWorkflowHandlerAttachment.class);
	}

	public void cleanAttachments(String uid, String uwfid, Integer step) {
		oaCtx.deleteFrom(UWHA).where(UWHA.UWFID.eq(uwfid).and(UWHA.UID.eq(uid)).and(UWHA.STEP.eq(step))).execute();
	}
	
	public void cleanAttachmentsForUwfid(String uwfid) {
		oaCtx.deleteFrom(UWHA).where(UWHA.UWFID.eq(uwfid)).execute();
	}
}
