package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.Position;
import com.jz.jooq.oa.tables.records.PositionRecord;

@Lazy
@Repository
public class OAPositionRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.Position P = Tables.POSITION;

	public List<Position> getAllPosition() {
		return oaCtx.selectFrom(P).fetchInto(Position.class);
	}

	public List<Position> mutiGetPositions(Collection<String> positionIds) {
		return oaCtx.selectFrom(P).where(P.ID.in(positionIds)).fetchInto(Position.class);
	}

	public Position getPosition(String positionId) {
		return oaCtx.selectFrom(P).where(P.ID.eq(positionId)).fetchAnyInto(Position.class);
	}

	public List<Position> listAllPosition(String name, int start, int size) {
		return oaCtx.selectFrom(P)
				.where(StringUtils.isEmpty(name) ? DSL.trueCondition() : P.NAME.like("%" + name + "%"))
				.orderBy(P.CREATE_TIME.desc()).limit(start, size).fetchInto(Position.class);
	}

	public boolean checkPositionExist(String name, String deptId) {
		return oaCtx.fetchExists(P, P.NAME.eq(name).and(P.DEPT_ID.eq(deptId)));
	}

	public void createPosition(String id, String deptId, String name) {
		oaCtx.insertInto(P).set(new PositionRecord(id, deptId, name, null, System.currentTimeMillis())).execute();
	}

	public void updatePosition(String id, String deptId, String name) {
		PositionRecord record = new PositionRecord();
		record.setDeptId(deptId);
		record.setName(name);
		oaCtx.update(P).set(record).where(P.ID.eq(id)).execute();
	}

	public void deletePosition(String id) {
		oaCtx.deleteFrom(P).where(P.ID.eq(id)).execute();
	}

	public boolean checkName(String name, String deptId) {
		return oaCtx.fetchExists(P, P.NAME.eq(name).and(P.DEPT_ID.eq(deptId)));
	}

	public void deletePositionDeptId(String deptId) {
		oaCtx.deleteFrom(P).where(P.DEPT_ID.eq(deptId)).execute();
	}

	public int cntPositions(String name) {
		return oaCtx.fetchCount(P, StringUtils.isEmpty(name) ? DSL.trueCondition() : P.NAME.like("%" + name + "%"));
	}

}
