package com.jz.jar.oa.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserRewardsAndPunishment;
import com.jz.jooq.oa.tables.records.UserRewardsAndPunishmentRecord;

@Lazy
@Repository
public class UserRewardsAndPunishmentRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserRewardsAndPunishment R = Tables.USER_REWARDS_AND_PUNISHMENT;

	public void updateUserRewardsAndPunishment(String fuid, List<UserRewardsAndPunishmentRecord> rpRecords) {
		oaCtx.deleteFrom(R).where(R.UID.eq(fuid)).execute();
		oaCtx.batchInsert(rpRecords).execute();
	}

	public List<UserRewardsAndPunishment> getUserRewardsAndPunishments(String fuid) {
		return oaCtx.selectFrom(R).where(R.UID.eq(fuid)).fetchInto(UserRewardsAndPunishment.class);
	}

}
