/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserVacationLeft;
import com.jz.jooq.oa.tables.records.UserVacationLeftRecord;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserVacationLeftRepository
extends OABaseRepository {
    private static final UserVacationLeft L = Tables.USER_VACATION_LEFT;

    public com.jz.jooq.oa.tables.pojos.UserVacationLeft getUserVacationLeft(String uid) {
        return (com.jz.jooq.oa.tables.pojos.UserVacationLeft)this.oaCtx.selectFrom((Table)L).where(new Condition[]{UserVacationLeftRepository.L.UID.eq((Object)uid)}).fetchAnyInto(com.jz.jooq.oa.tables.pojos.UserVacationLeft.class);
    }

    public List<com.jz.jooq.oa.tables.pojos.UserVacationLeft> getUserVacationLeft(Collection<String> filterUids) {
        return this.oaCtx.selectFrom((Table)L).where(new Condition[]{UserVacationLeftRepository.L.UID.in(filterUids)}).fetchInto(com.jz.jooq.oa.tables.pojos.UserVacationLeft.class);
    }

    public void createUserVacationLeft(String uid, BigDecimal overtimeDay) {
        this.oaCtx.insertInto((Table)L).set((Record)new UserVacationLeftRecord(uid, new BigDecimal(0), new BigDecimal(0), overtimeDay, new BigDecimal(0), Long.valueOf(System.currentTimeMillis()))).execute();
    }

    public void updateVacationLeft(String uid, double fixedAnnualVacation, double compensatedLeave) {
        UserVacationLeftRecord record = new UserVacationLeftRecord();
        record.setUid(uid);
        record.setFixedAnnualVacation(new BigDecimal(fixedAnnualVacation));
        record.setCompensatedLeave(new BigDecimal(compensatedLeave));
        record.setLastUpdated(Long.valueOf(System.currentTimeMillis()));
        this.oaCtx.insertInto((Table)L).set((Record)record).onDuplicateKeyUpdate().set((Record)record).execute();
    }

    public void addFixedAnnualVacation(String uid, double leaveDay) {
        this.oaCtx.update((Table)L).set((Field)UserVacationLeftRepository.L.FIXED_ANNUAL_VACATION, UserVacationLeftRepository.L.FIXED_ANNUAL_VACATION.add((Number)leaveDay)).set((Field)UserVacationLeftRepository.L.LAST_UPDATED, (Object)System.currentTimeMillis()).where(new Condition[]{UserVacationLeftRepository.L.UID.eq((Object)uid)}).execute();
    }

    public void addFloatAnnualVacation(String uid, double leaveDay) {
        this.oaCtx.update((Table)L).set((Field)UserVacationLeftRepository.L.FLOAT_ANNUAL_VACATION, UserVacationLeftRepository.L.FLOAT_ANNUAL_VACATION.add((Number)leaveDay)).set((Field)UserVacationLeftRepository.L.LAST_UPDATED, (Object)System.currentTimeMillis()).where(new Condition[]{UserVacationLeftRepository.L.UID.eq((Object)uid)}).execute();
    }

    public void addCompensatedLeave(String uid, double leaveDay) {
        this.oaCtx.update((Table)L).set((Field)UserVacationLeftRepository.L.COMPENSATED_LEAVE, UserVacationLeftRepository.L.COMPENSATED_LEAVE.add((Number)leaveDay)).set((Field)UserVacationLeftRepository.L.LAST_UPDATED, (Object)System.currentTimeMillis()).where(new Condition[]{UserVacationLeftRepository.L.UID.eq((Object)uid)}).execute();
    }

    public void addPaidSickLeave(String uid, double leaveDay) {
        this.oaCtx.update((Table)L).set((Field)UserVacationLeftRepository.L.PAID_SICK_LEAVE, UserVacationLeftRepository.L.PAID_SICK_LEAVE.add((Number)leaveDay)).set((Field)UserVacationLeftRepository.L.LAST_UPDATED, (Object)System.currentTimeMillis()).where(new Condition[]{UserVacationLeftRepository.L.UID.eq((Object)uid)}).execute();
    }
}

