package com.jz.jar.oa.proxy;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.oa.finals.OAFinial;
import com.jz.jar.oa.service.OAUserService;

/**
 * @Title OAUserProxy
 * @Package com.jz.jar.oa.proxy
 * @author tangjunfeng
 * @date 2019年3月25日 下午3:53:27
 * @version V1.0
 */
@Lazy
@Service
public class OAUserProxy {

	@Autowired
	private OAUserService userService;

	/** 获取不包括CEO的所有直属上级 */
	public List<String> getLeadersWithoutCEO(String uid) {
		int n = 10;
		return getLeadersWithoutCEO(uid, Lists.newArrayList(), n);
	}

	/** 获取不包括CEO的所有直属上级 */
	public List<String> getLeadersWithoutCEO(String uid, List<String> leaders, int n) {
		if (n < 0) {
			return leaders;
		}
		String superior = userService.getSuperiorUid(uid);
		if (StringTools.isEmpty(superior) || superior.equals(OAFinial.CEO_UID) || leaders.contains(superior)) {
			return leaders;
		}
		leaders.add(superior);
		--n;
		return getLeadersWithoutCEO(superior, leaders, n);
	}

}
