package com.jz.jar.oa.proxy;

import java.util.LinkedHashMap;

/**
 * @Title CustomLinkedHashMap
 * @Package com.jz.jar.oa.proxy
 * @author tangjunfeng
 * @date 2019年4月8日 下午2:00:18
 * @version V1.0
 */
@SuppressWarnings("serial")
public class CustomLinkedHashMap<K, V> extends LinkedHashMap<K, V> {

	@Override
	public V put(K key, V value) {
		return removePutIfPresent(key, value);
	}

	public V removePutIfPresent(K key, V value) {
		if (containsKey(key))
			remove(key);
		return super.put(key, value);
	}
}
