package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.records.UserRecord;

@Lazy
@Repository
public class OAUserRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.User U = Tables.USER;
	private static final String COMPANYDELETED = "companyDeleted";
	private static final String DEPTDELETED = "deptDeleted";
	private static final String POSITIONDELETED = "positionDeleted";
	private static final String WORKADDRDELETED = "workAddrDeleted";

	public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId,
			String workAddrId, String deptId, String positionId, String superiorId, String joinDate, String relations,
			Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate,
			int status) {
		oaCtx.insertInto(U).set(U.UID, uid).set(U.CHINESE_NAME, chineseName).set(U.ENGLISH_NAME, englishName)
				.set(U.PHONE, phone).set(U.COMPANY_ID, companyId).set(U.WORK_ADDR_ID, workAddrId).set(U.DEPT_ID, deptId)
				.set(U.POSITION_ID, positionId).set(U.SUPERIOR_ID, superiorId).set(U.JOIN_DATE, joinDate)
				.set(U.RELATIONS, relations).set(U.INSURANCE, insurance).set(U.CHILD_FREE, childFree)
				.set(U.TRAIN_AGREEMENT, trainAgreement).set(U.ANNUAL_LEAVE_DAYS, annualLeaveDays)
				.set(U.CERTIFICATE, certificate).set(U.STATUS, status).onDuplicateKeyUpdate()
				.set(U.CHINESE_NAME, chineseName).set(U.ENGLISH_NAME, englishName).set(U.PHONE, phone)
				.set(U.COMPANY_ID, companyId).set(U.WORK_ADDR_ID, workAddrId).set(U.DEPT_ID, deptId)
				.set(U.POSITION_ID, positionId).set(U.SUPERIOR_ID, superiorId).set(U.JOIN_DATE, joinDate)
				.set(U.RELATIONS, relations).set(U.INSURANCE, insurance).set(U.CHILD_FREE, childFree)
				.set(U.TRAIN_AGREEMENT, trainAgreement).set(U.ANNUAL_LEAVE_DAYS, annualLeaveDays)
				.set(U.CERTIFICATE, certificate).set(U.STATUS, status).execute();
	}

	public void updateUserStatus(String uid, int status) {
		oaCtx.update(U).set(U.STATUS, status).where(U.UID.eq(uid)).execute();
	}

	public User getUser(String uid) {
		return oaCtx.selectFrom(U).where(U.UID.eq(uid).and(U.STATUS.eq(1))).fetchAnyInto(User.class);
	}

	public User getUserInfo(String uid) {
		return oaCtx.selectFrom(U).where(U.UID.eq(uid)).fetchAnyInto(User.class);
	}

	public List<User> mutGetUsers(Collection<String> uids) {
		return oaCtx.selectFrom(U).where(U.UID.in(uids).and(U.STATUS.eq(1))).fetchInto(User.class);
	}

	public List<User> mutGetAllUsers(Collection<String> uids) {
		return oaCtx.selectFrom(U).where(U.UID.in(uids)).fetchInto(User.class);
	}

	public List<User> multiGetSimpleUser(Collection<String> uids) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.ENGLISH_NAME).from(U).where(U.UID.in(uids).and(U.STATUS.eq(1)))
				.fetchInto(User.class);
	}

	public List<User> multiGetAllSimpleUser(Collection<String> uids) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.ENGLISH_NAME).from(U).where(U.UID.in(uids)).fetchInto(User.class);
	}

	public User getSimpleUser(String uid) {
		return oaCtx.select(U.UID, U.SUPERIOR_ID, U.CHINESE_NAME, U.ENGLISH_NAME, U.POSITION_ID, U.COMPANY_ID).from(U)
				.where(U.UID.eq(uid).and(U.STATUS.eq(1))).fetchAnyInto(User.class);
	}

	public User getAllSimpleUser(String uid) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.ENGLISH_NAME).from(U).where(U.UID.eq(uid))
				.fetchAnyInto(User.class);
	}

	public boolean isIncumbency(String uid) {
		return oaCtx.fetchExists(U, U.UID.eq(uid).and(U.STATUS.eq(1)));
	}

	public int cntDeptUser(String deptId) {
		return oaCtx.fetchCount(U, U.DEPT_ID.eq(deptId).and(U.STATUS.eq(1)));
	}

	public void updateUserDept(String deptId) {
		oaCtx.update(U).set(U.DEPT_ID, DEPTDELETED).where(U.DEPT_ID.eq(deptId)).execute();
	}

	public int cntPositionUser(String id) {
		return oaCtx.fetchCount(U, U.POSITION_ID.eq(id).and(U.STATUS.eq(1)));
	}

	public void updateUserPosition(String id) {
		oaCtx.update(U).set(U.POSITION_ID, POSITIONDELETED).where(U.POSITION_ID.eq(id)).execute();
	}

	public Map<String, Integer> getStaffNumByCompanyIds(Collection<String> companyIds) {
		List<Map<String, Object>> list = oaCtx.select(U.COMPANY_ID.as("companyId"), DSL.count().as("cnt")).from(U)
				.where(U.COMPANY_ID.in(companyIds).and(U.STATUS.eq(1))).groupBy(U.COMPANY_ID).fetchMaps();
		Map<String, Integer> rsMap = Maps.newHashMap();
		for (Map<String, Object> map : list) {
			rsMap.put(MapUtils.getString(map, "companyId"), MapUtils.getIntValue(map, "cnt"));
		}
		return rsMap;
	}

	public int cntCompanyUser(String id) {
		return oaCtx.fetchCount(U, U.COMPANY_ID.eq(id).and(U.STATUS.eq(1)));
	}

	public void updateUserCompany(String id) {
		oaCtx.update(U).set(U.COMPANY_ID, COMPANYDELETED).where(U.COMPANY_ID.eq(id)).execute();
	}

	public Map<String, Integer> getStaffNumByWorkAddressIds(Collection<String> workAddressIds) {
		List<Map<String, Object>> list = oaCtx.select(U.WORK_ADDR_ID.as("workAddressId"), DSL.count().as("cnt")).from(U)
				.where(U.WORK_ADDR_ID.in(workAddressIds).and(U.STATUS.eq(1))).groupBy(U.WORK_ADDR_ID).fetchMaps();
		Map<String, Integer> rsMap = Maps.newHashMap();
		for (Map<String, Object> map : list) {
			rsMap.put(MapUtils.getString(map, "workAddressId"), MapUtils.getIntValue(map, "cnt"));
		}
		return rsMap;
	}

	public int cntWorkAddressUser(String id) {
		return oaCtx.fetchCount(U, U.WORK_ADDR_ID.eq(id).and(U.STATUS.eq(1)));
	}

	public int cntAllWorkAddressUser(String id) {
		return oaCtx.fetchCount(U, U.WORK_ADDR_ID.eq(id));
	}

	public void updateUserWorkAddress(String id) {
		oaCtx.update(U).set(U.WORK_ADDR_ID, WORKADDRDELETED).where(U.WORK_ADDR_ID.eq(id)).execute();
	}

	public Map<String, Integer> getStaffNumByDeptIds(Collection<String> deptIds) {
		List<Map<String, Object>> list = oaCtx.select(U.DEPT_ID.as("deptId"), DSL.count().as("cnt")).from(U)
				.where(U.DEPT_ID.in(deptIds).and(U.STATUS.eq(1))).groupBy(U.DEPT_ID).fetchMaps();
		Map<String, Integer> rsMap = Maps.newHashMap();
		for (Map<String, Object> map : list) {
			rsMap.put(MapUtils.getString(map, "deptId"), MapUtils.getIntValue(map, "cnt"));
		}
		return rsMap;
	}

	public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
		return oaCtx.selectFrom(U).where(this.searchWhereCondition(companyId, keyword)).and(U.STATUS.eq(1))
				.orderBy(U.JOIN_DATE.asc(), U.UID.desc()).limit(start, size).fetchInto(User.class);
	}

	private Condition searchWhereCondition(String companyId, String keyword) {
		Condition condition = DSL.trueCondition();
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(U.COMPANY_ID.eq(companyId));
		}
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition
					.and(U.CHINESE_NAME.like("%" + keyword + "%").or(U.ENGLISH_NAME.like("%" + keyword + "%")));
		}
		return condition;
	}

	public User getUserByPosition(String positionId) {
		return oaCtx.selectFrom(U).where(U.POSITION_ID.eq(positionId)).fetchAnyInto(User.class);
	}

	public List<String> getDeptIdsForCompany(String companyId) {
		return oaCtx.selectDistinct(U.DEPT_ID).from(U).where(U.COMPANY_ID.eq(companyId).and(U.STATUS.eq(1)))
				.fetchInto(String.class);
	}

	public List<User> getUsersForDepartment(String companyId, String deptId) {
		return oaCtx.select(U.UID, U.CHINESE_NAME).from(U)
				.where(U.COMPANY_ID.eq(companyId).and(U.STATUS.eq(1)).and(U.DEPT_ID.eq(deptId))).fetchInto(User.class);
	}

	public User getUserByPhone(String phone) {
		return oaCtx.selectFrom(U).where(U.PHONE.eq(phone).and(U.STATUS.eq(1))).fetchAnyInto(User.class);
	}

	public String getSuperiorUid(String uid) {
		return oaCtx.select(U.SUPERIOR_ID).from(U).where(U.UID.eq(uid).and(U.STATUS.eq(1))).fetchAnyInto(String.class);
	}

	public void updateSuperior(String currentlySuperior, String newSuperior) {
		oaCtx.update(U).set(U.SUPERIOR_ID, newSuperior).where(U.SUPERIOR_ID.eq(currentlySuperior)).execute();
	}

	public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.ENGLISH_NAME).from(U).where(U.WORK_ADDR_ID.eq(workAddrId))
				.orderBy(U.JOIN_DATE.desc(), U.UID.desc()).limit(start, size).fetchInto(User.class);
	}

	private Condition getConditions(String uid, String departmentId, String companyId, String workAddrId,
			String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
		Condition condition = DSL.trueCondition();
		if (ArrayMapTools.isNotEmpty(filterWorkAddrIds) && ArrayMapTools.isNotEmpty(filterCompanyIds))
			condition = condition.and(U.WORK_ADDR_ID.in(filterWorkAddrIds)).and(U.COMPANY_ID.in(filterCompanyIds));
		if (StringUtils.isNotEmpty(departmentId)) {
			condition = condition.and(U.DEPT_ID.eq(departmentId));
		}
		if (StringUtils.isNotEmpty(companyId)) {
			condition = condition.and(U.COMPANY_ID.eq(companyId));
		}
		if (StringUtils.isNotEmpty(workAddrId)) {
			condition = condition.and(U.WORK_ADDR_ID.eq(workAddrId));
		}
		if (StringUtils.isNotEmpty(keyword)) {
			condition = condition.and(U.CHINESE_NAME.like("%" + keyword + "%")
					.or(U.ENGLISH_NAME.like("%" + keyword + "%")).or(U.PHONE.like("%" + keyword + "%")));
		}
		return condition;
	}

	public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId,
			String workAddrId, String keyword, Collection<String> filterWorkAddrIds,
			Collection<String> filterCompanyIds, int start, int size) {
		return oaCtx.select(U.UID).from(U)
				.where(this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds,
						filterCompanyIds))
				.orderBy(U.JOIN_DATE.asc(), U.UID.desc()).limit(start, size).fetchInto(String.class);
	}

	public List<String> filterIncumbentUidsByConditionsLimit(String uid, String departmentId, String companyId,
			String workAddrId, String keyword, Collection<String> filterWorkAddrIds,
			Collection<String> filterCompanyIds, int start, int size) {
		return oaCtx.select(U.UID).from(U)
				.where(this.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds,
						filterCompanyIds).and(U.STATUS.eq(1)))
				.orderBy(U.JOIN_DATE.asc(), U.UID.desc()).limit(start, size).fetchInto(String.class);
	}

	public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId,
			String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
		return oaCtx.fetchCount(U, this.getConditions(uid, departmentId, companyId, workAddrId, keyword,
				filterWorkAddrIds, filterCompanyIds));
	}

	public int cntIncumbentUsersByConditions(String uid, String departmentId, String companyId, String workAddrId,
			String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
		return oaCtx.fetchCount(U, this
				.getConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds)
				.and(U.STATUS.eq(1)));
	}

	public int cntUsers(Collection<String> filterUids) {
		return oaCtx.fetchCount(U, U.UID.in(filterUids));
	}

	public List<String> filterRegularEmployee(String date) {
		return oaCtx.select(U.UID).from(U).where(U.STATUS.eq(1).and(U.JOIN_DATE.ge(date))).fetchInto(String.class);
	}

	public void addFloatAnnualLeaveDays(Collection<String> filterUids) {
		oaCtx.update(U).set(U.FLOAT_ANNUAL_LEAVE_DAYS, U.FLOAT_ANNUAL_LEAVE_DAYS.add(1)).where(U.UID.in(filterUids))
				.execute();
	}

	public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId,
			String keyword) {
		return oaCtx.fetchCount(U, this
				.getConditions(uid, departmentId, companyId, workAddrId, keyword, Sets.newHashSet(), Sets.newHashSet())
				.and(U.STATUS.eq(status)));
	}

	public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId,
			String workAddrId, String keyword, int start, int size) {
		return oaCtx.selectFrom(U)
				.where(U.STATUS.eq(status)
						.and(this.getConditions(uid, departmentId, companyId, workAddrId, keyword, Sets.newHashSet(),
								Sets.newHashSet())))
				.orderBy(U.JOIN_DATE.desc(), U.UID.asc()).limit(start, size).fetchInto(User.class);
	}

	public List<User> getRegularEmployees() {
		return oaCtx.selectFrom(U).where(U.STATUS.eq(1)).fetchInto(User.class);
	}

	public List<User> getHrList(Collection<String> hrs) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.ENGLISH_NAME).from(U).where(U.STATUS.eq(1).and(U.UID.in(hrs)))
				.fetchInto(User.class);
	}

	public List<String> findUserIdForWorkAddress(Collection<String> workAddressIds) {
		return oaCtx.select(U.UID).from(U).where(U.WORK_ADDR_ID.in(workAddressIds).and(U.STATUS.eq(1)))
				.fetchInto(String.class);
	}

	public List<String> getCompanyForUser(Collection<String> uids) {
		return oaCtx.selectDistinct(U.COMPANY_ID).from(U).where(U.UID.in(uids).and(U.STATUS.eq(1)))
				.fetchInto(String.class);
	}

	public void changeToResignation(String uid, int status, String resignationDate) {
		oaCtx.update(U).set(U.STATUS, status).set(U.RESIGNATION_DATE, resignationDate).where(U.UID.eq(uid)).execute();
	}

	public List<String> filterUids(String keyword) {
		return oaCtx.select(U.UID).from(U)
				.where(StringUtils.isEmpty(keyword) ? DSL.trueCondition()
						: (U.CHINESE_NAME.like("%" + keyword + "%")).or(U.ENGLISH_NAME.like("%" + keyword + "%")))
				.fetchInto(String.class);
	}

	public List<String> getUsersByPosition(String positionId) {
		return oaCtx.select(U.UID).from(U).where(U.POSITION_ID.eq(positionId)).fetchInto(String.class);
	}

	public void createUser(UserRecord record) {
		oaCtx.insertInto(U).set(record).onDuplicateKeyUpdate().set(record).execute();
	}

	public void updateUser(String fuid, String chineseName, String englishName, String phone, int status,
			String cardType, String cardBak, String nationality, String country, String fertility, String residenceType,
			String residenceAddress, String contactAddress, String landline, String emergencyContact,
			String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate) {
		oaCtx.update(U).set(U.CHINESE_NAME, chineseName).set(U.ENGLISH_NAME, englishName).set(U.PHONE, phone)
				.set(U.STATUS, status).set(U.CARD_TYPE, cardType).set(U.CARD_BAK, cardBak)
				.set(U.NATIONALITY, nationality).set(U.COUNTRY, country).set(U.FERTILITY, fertility)
				.set(U.RESIDENCE_TYPE, residenceType).set(U.RESIDENCE_ADDRESS, residenceAddress)
				.set(U.CONTACT_ADDRESS, contactAddress).set(U.LANDLINE, landline)
				.set(U.EMERGENCY_CONTACT, emergencyContact).set(U.EMERGENCY_PHONE, emergencyPhone)
				.set(U.INSURANCE, insurance).set(U.CHILD_FREE, childFree).set(U.TRAIN_AGREEMENT, trainAgreement)
				.set(U.JOIN_DATE, joinDate).where(U.UID.eq(fuid)).execute();
	}

	public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate,
			String contractStart, String contractEnd, String contractType, String contractNature, String deptId,
			String positionId, String superiorId, String relations, String workAddrId, String companyId,
			String laborUnion, String costCenter) {
		oaCtx.update(U).set(U.JOIN_CHANNEL, joinChannel).set(U.REFERRER, referrer)
				.set(U.OFFICIAL_JOIN_DATE, officialJoinDate).set(U.CONTRACT_START, contractStart)
				.set(U.CONTRACT_END, contractEnd).set(U.CONTRACT_TYPE, contractType)
				.set(U.CONTRACT_NATURE, contractNature).set(U.DEPT_ID, deptId).set(U.POSITION_ID, positionId)
				.set(U.SUPERIOR_ID, superiorId).set(U.RELATIONS, relations).set(U.WORK_ADDR_ID, workAddrId)
				.set(U.COMPANY_ID, companyId).set(U.LABOR_UNION, laborUnion).set(U.COST_CENTER, costCenter)
				.where(U.UID.eq(fuid)).execute();
	}

	public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
		oaCtx.update(U).set(U.BACKGROUND_SURVEY, backgroundSurvey).where(U.UID.eq(fuid)).execute();
	}

	public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund,
			String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays,
			String certificate, Integer oldLeaveDays, String leaveAdjustDate) {
		UpdateSetMoreStep<UserRecord> moreStep = oaCtx.update(U).set(U.BANK_ACCOUNT, bankAccount).set(U.BANK, bank)
				.set(U.BANK_AREA, bankArea).set(U.FUND, fund).set(U.SOCIAL_SECURITY_TYPE, socialSecurityType)
				.set(U.SOCIAL_SECURITY_AREA, socialSecurityArea).set(U.TAX, tax)
				.set(U.ANNUAL_LEAVE_DAYS, annualLeaveDays).set(U.CERTIFICATE, certificate);
		if (StringUtils.isNotEmpty(leaveAdjustDate) && oldLeaveDays != annualLeaveDays) {
			moreStep.set(U.OLD_LEAVE_DAYS, oldLeaveDays).set(U.LEAVE_ADJUST_DATE, leaveAdjustDate);
		}
		moreStep.where(U.UID.eq(fuid)).execute();
	}

	public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart,
			String contractEnd, String contractType, String contractNature) {
		String _null = null;
		oaCtx.update(U).set(U.JOIN_DATE, joinDate).set(U.OFFICIAL_JOIN_DATE, officialJoinDate)
				.set(U.CONTRACT_START, contractStart).set(U.CONTRACT_END, contractEnd)
				.set(U.CONTRACT_TYPE, contractType).set(U.CONTRACT_NATURE, contractNature)
				.set(U.RESIGNATION_DATE, _null).set(U.STATUS, 1).where(U.UID.eq(fuid)).execute();
	}

	public List<User> multiGetUserAddr(Collection<String> uids) {
		return oaCtx.select(U.UID, U.CHINESE_NAME, U.WORK_ADDR_ID).from(U).where(U.UID.in(uids)).fetchInto(User.class);
	}

	public List<String> filterSubordinates(Collection<String> subordinates) {
		return oaCtx.select(U.UID).from(U).where(U.SUPERIOR_ID.in(subordinates)).fetchInto(String.class);
	}

	public String getUserWorkAddress(String uid) {
		return oaCtx.select(U.WORK_ADDR_ID).from(U).where(U.UID.eq(uid)).fetchAnyInto(String.class);
	}

	public Integer getOldLeaveDays(String fuid) {
		return oaCtx.select(U.ANNUAL_LEAVE_DAYS).from(U).where(U.UID.eq(fuid)).fetchAnyInto(Integer.class);
	}

}
