package com.jz.jar.oa.wrapper;

import java.util.List;

import com.jz.common.utils.text.StringTools;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditAttachmentLog;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditLog;

public class WorkflowAuditLog {

	private String id;
	private String operator;
	private String name;
	private String handleName;
	private String positionName;
	private Integer step;
	private Integer auditStatus;
	private String remarks;
	private Boolean isAddSignature;
	private String addSignatureReason;
	private Long auditTime;
	// 处理人附件
	private List<UserWorkflowAuditAttachmentLog> attachments;

	public static WorkflowAuditLog of(User user, UserWorkflowAuditLog log) {
		WorkflowAuditLog result = new WorkflowAuditLog().setOperator(user.getUid()).setName(user.getChineseName())
				.setHandleName(log.getHandleName()).setStep(log.getStep()).setPositionName(log.getPositionName())
				.setAuditStatus(log.getResult()).setRemarks(log.getRemarks());
		if (null != log.getResult())
			result.setAuditTime(log.getCreateTime());
		// 加签
		if (StringTools.isNotEmptyAndBlank(log.getReason())) {
			result.setIsAddSignature(true).setAddSignatureReason(log.getReason());
		}
		return result;
	}

	public String getId() {
		return id;
	}

	public WorkflowAuditLog setId(String id) {
		this.id = id;
		return this;
	}

	public String getOperator() {
		return operator;
	}

	public WorkflowAuditLog setOperator(String operator) {
		this.operator = operator;
		return this;
	}

	public String getName() {
		return name;
	}

	public WorkflowAuditLog setName(String name) {
		this.name = name;
		return this;
	}

	public String getHandleName() {
		return handleName;
	}

	public WorkflowAuditLog setHandleName(String handleName) {
		this.handleName = handleName;
		return this;
	}

	public Integer getStep() {
		return step;
	}

	public WorkflowAuditLog setStep(Integer step) {
		this.step = step;
		return this;
	}

	public String getPositionName() {
		return positionName;
	}

	public WorkflowAuditLog setPositionName(String positionName) {
		this.positionName = positionName;
		return this;
	}

	public Integer getAuditStatus() {
		return auditStatus;
	}

	public WorkflowAuditLog setAuditStatus(Integer auditStatus) {
		this.auditStatus = auditStatus;
		return this;
	}

	public String getRemarks() {
		return remarks;
	}

	public WorkflowAuditLog setRemarks(String remarks) {
		this.remarks = remarks;
		return this;
	}

	public Boolean getIsAddSignature() {
		return isAddSignature;
	}

	public WorkflowAuditLog setIsAddSignature(Boolean isAddSignature) {
		this.isAddSignature = isAddSignature;
		return this;
	}

	public String getAddSignatureReason() {
		return addSignatureReason;
	}

	public WorkflowAuditLog setAddSignatureReason(String addSignatureReason) {
		this.addSignatureReason = addSignatureReason;
		return this;
	}

	public Long getAuditTime() {
		return auditTime;
	}

	public WorkflowAuditLog setAuditTime(Long auditTime) {
		this.auditTime = auditTime;
		return this;
	}

	public List<UserWorkflowAuditAttachmentLog> getAttachments() {
		return attachments;
	}

	public WorkflowAuditLog setAttachments(List<UserWorkflowAuditAttachmentLog> attachments) {
		this.attachments = attachments;
		return this;
	}

}
