package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditAttachmentLog;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditLog;
import com.jz.jooq.oa.tables.records.UserWorkflowAuditAttachmentLogRecord;
import com.jz.jooq.oa.tables.records.UserWorkflowAuditLogRecord;

@Lazy
@Repository
public class UserWorkflowAuditLogRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowAuditLog L = Tables.USER_WORKFLOW_AUDIT_LOG;
	private static final com.jz.jooq.oa.tables.UserWorkflowAuditAttachmentLog AL = Tables.USER_WORKFLOW_AUDIT_ATTACHMENT_LOG;

	public void addAuditLog(String id, String uwfid, String operator, String handleName, String positionName,
			Integer step, UserWorkflow result, String remarks, String reason, String extType) {
		UserWorkflowAuditLogRecord record = new UserWorkflowAuditLogRecord();
		record.setId(id);
		record.setUwfid(uwfid);
		record.setOperator(operator);
		record.setHandleName(handleName);
		record.setPositionName(positionName);
		record.setStep(step);
		record.setResult(result.getCode());
		record.setRemarks(remarks);
		record.setReason(reason);
		record.setExtType(extType);
		record.setCreateTime(System.currentTimeMillis());
		oaCtx.insertInto(L).set(record).onDuplicateKeyUpdate().set(record).execute();
	}

	public void addUserWorkflowAttachmentLog(String logId, Map<String, String> attachmentName2Path) {
		List<UserWorkflowAuditAttachmentLogRecord> attachmentRecords = Lists.newArrayList();
		attachmentName2Path.forEach((name, url) -> {
			attachmentRecords.add(new UserWorkflowAuditAttachmentLogRecord(null, logId, name, url));
		});
		oaCtx.batchInsert(attachmentRecords).execute();
	}

	public List<UserWorkflowAuditLog> getUserWorkflowAuditLogs(String uwfid) {
		return oaCtx.selectFrom(L).where(L.UWFID.eq(uwfid)).orderBy(L.CREATE_TIME.asc())
				.fetchInto(UserWorkflowAuditLog.class);
	}

	public List<UserWorkflowAuditAttachmentLog> mutiGetAttachmentsLog(Collection<String> logIds) {
		return oaCtx.selectFrom(AL).where(AL.LOG_ID.in(logIds)).fetchInto(UserWorkflowAuditAttachmentLog.class);
	}
}
