/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OACompanyRepository;
import com.jz.jooq.oa.tables.pojos.Company;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OACompanyService {
    @Autowired
    private OACompanyRepository companyRepository;

    public List<Company> getAllCompany() {
        return this.companyRepository.getAllCompany();
    }

    public List<Company> getAllCompanySimple() {
        return this.companyRepository.getAllCompanySimple();
    }

    public List<Company> multiGetCompanies(Collection<String> companyIds) {
        return this.companyRepository.multiGetCompanies(companyIds);
    }

    public Map<String, Company> mutiGetCompanyMap(Collection<String> companyIds) {
        List<Company> list = this.companyRepository.mutiGetCompanys(companyIds);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
    }

    public Map<String, Company> multiGetSimpleCompanies(Collection<String> companyIds) {
        List<Company> list = this.companyRepository.multiGetSimpleCompanies(companyIds);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getId(), it -> it));
    }

    public Company getCompany(String companyId) {
        return this.companyRepository.getCompany(companyId);
    }

    public boolean checkName(String name) {
        return this.companyRepository.checkName(name);
    }

    public boolean checkExist(String id) {
        return this.companyRepository.checkExist(id);
    }

    public void createCompany(String id, String name, String license, String accounter, String cashier, String assetsKeeperIT, String assetsKeeperWork, String law) {
        this.companyRepository.createCompany(id, name, license, accounter, cashier, assetsKeeperIT, assetsKeeperWork, law);
    }

    public void updateCompany(String id, String name, String license, String accounter, String cashier, String assetsKeeperIT, String assetsKeeperWork, String law) {
        this.companyRepository.updateCompany(id, name, license, accounter, cashier, assetsKeeperIT, assetsKeeperWork, law);
    }

    public void deleteCompany(String id) {
        this.companyRepository.deleteCompany(id);
    }

    public List<Company> getCompanyForAssetsManager(String assetsKeeper) {
        return this.companyRepository.getCompanyForAssetsManager(assetsKeeper);
    }

    public List<String> getCompanyIdForAssetsManager(String assetsKeeper) {
        return this.companyRepository.getCompanyIdForAssetsManager(assetsKeeper);
    }

    public boolean isAssetManager(String companyId, String uid, boolean isIt) {
        return this.companyRepository.isAssetManager(companyId, uid, isIt);
    }

    public void updateAssetsKeeper(String currentlyKeeper, String newKeeper) {
        this.companyRepository.updateAssetsKeeper(currentlyKeeper, newKeeper);
    }

    public void updateAccounter(String currentlyAccounter, String newAccounter) {
        this.companyRepository.updateAccounter(currentlyAccounter, newAccounter);
    }

    public void updateCashier(String currentlyCashier, String newCashier) {
        this.companyRepository.updateCashier(currentlyCashier, newCashier);
    }

    public void updateLaw(String currentlyLaw, String newLaw) {
        this.companyRepository.updateLaw(currentlyLaw, newLaw);
    }

    public List<String> getCompanyIdForAccounter(String accounter) {
        return this.companyRepository.getCompanyIdForAccounter(accounter);
    }

    public List<Company> getFilteredCompany(String name) {
        return this.companyRepository.getFilteredCompany(name);
    }

    public boolean isAssetsKeeper(String uid) {
        return this.companyRepository.isAssetsKeeper(uid);
    }

    public List<String> filterUidCompanyIds(String uid) {
        return this.companyRepository.filterUidCompanyIds(uid);
    }

    public List<String> filterSubordinatesCompanyIds(Collection<String> subordinateUids) {
        return this.companyRepository.filterSubordinatesCompanyIds(subordinateUids);
    }
}

