/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.datetime.TimeTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.oa.cache.WorkflowIdentifyCache;
import com.jz.jar.oa.enmus.WorkflowType;
import com.jz.jar.oa.proxy.OAUserProxy;
import com.jz.jar.oa.service.OACompanyService;
import com.jz.jar.oa.service.OAPositionService;
import com.jz.jar.oa.service.OAUserService;
import com.jz.jar.oa.service.OAWorkAddressService;
import com.jz.jar.oa.service.WorkflowSettingService;
import com.jz.jar.oa.wrapper.PositionWrapper;
import com.jz.jar.oa.wrapper.WorkflowHandler;
import com.jz.jooq.oa.tables.pojos.Company;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.WorkAddress;
import com.jz.jooq.oa.tables.pojos.WorkflowSetting;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class WorkflowProxy {
    @Autowired
    private WorkflowSettingService workflowSettingService;
    @Autowired
    private OACompanyService companyService;
    @Autowired
    private OAUserService userService;
    @Autowired
    private OAUserProxy userProxy;
    @Autowired
    private OAWorkAddressService workAddressService;
    @Autowired
    private OAPositionService positionService;
    @Autowired
    private WorkflowIdentifyCache workflowIdentifyCache;

    public List<WorkflowHandler> getWorkflowHandlers(String uid, List<String> companyIds, String workAddrId, String wfid, String hr, UnaryOperator<List<WorkflowSetting>>[] unaryOperators) {
        User user = this.userService.getUser(uid);
        if (null == user) {
            return null;
        }
        WorkAddress workAddress = null;
        workAddress = StringUtils.equals((CharSequence)workAddrId, (CharSequence)user.getWorkAddrId()) || workAddrId == null ? this.workAddressService.getWorkAddress(user.getWorkAddrId()) : this.workAddressService.getWorkAddress(workAddrId);
        if (null == workAddress || StringTools.isEmpty((CharSequence)workAddress.getTimekeeper())) {
            throw new NullPointerException("\u65e0\u6548\u7684\u5de5\u4f5c\u5730\u70b9\u4fe1\u606f");
        }
        List<Company> companies = this.companyService.multiGetCompanies(companyIds);
        if (ArrayMapTools.isEmpty(companies)) {
            throw new NullPointerException("\u65e0\u6548\u7684\u516c\u53f8\u4fe1\u606f");
        }
        for (Company c : companies) {
            if (!StringTools.isAnyEmpty((CharSequence[])new CharSequence[]{c.getCashier(), c.getAccounter(), c.getAssetsKeeperIt(), c.getAssetsKeeperWork(), c.getLaw()})) continue;
            throw new NullPointerException("\u516c\u53f8\u4fe1\u606f\u4e0d\u5b8c\u6574");
        }
        List<WorkflowSetting> settings = this.getWorkflowSetting(wfid, unaryOperators);
        Company tempCompany = null;
        ArrayList handlers = Lists.newArrayList();
        for (WorkflowSetting workflowSetting : settings) {
            tempCompany = companies.get(workflowSetting.getCompanyIdx());
            this.addWorkflowHandler(user, tempCompany, workAddress, handlers, workflowSetting, hr);
        }
        if (handlers.isEmpty()) {
            return null;
        }
        HashSet uids = Sets.newHashSet();
        handlers.forEach(it -> uids.add(it.getUid()));
        Map<String, User> users = this.userService.mutiGetUserMap(uids);
        if (ArrayMapTools.isEmpty(users)) {
            return null;
        }
        Set<String> positionIds = users.values().stream().map(User::getPositionId).collect(Collectors.toSet());
        HashMap positions = this.positionService.mutiGetSimplePositionMap(positionIds);
        if (null == positions) {
            positions = Maps.newHashMap();
        }
        ArrayList resultHandlers = Lists.newArrayList();
        ArrayList carbonCopy = Lists.newArrayList();
        int i = 0;
        for (WorkflowHandler handler : handlers) {
            if (StringTools.isEmpty((CharSequence)handler.getUid()) || !users.containsKey(handler.getUid())) {
                throw new NullPointerException("Cann't found workflow handler for [" + uid + "], [" + wfid + "], [" + handler.getHandleName() + "]");
            }
            ++i;
            User tempUser = users.get(handler.getUid());
            handler.setName(tempUser.getChineseName());
            if (handler.getIsAddPosition().booleanValue() && positions.containsKey(tempUser.getPositionId())) {
                String positionName = ((PositionWrapper)positions.get(tempUser.getPositionId())).getName();
                handler.setHandleName(handler.getHandleName() + "(" + positionName + ")");
            }
            if (handler.getIsCarbonCopy().booleanValue()) {
                carbonCopy.add(handler);
                continue;
            }
            handler.setStep(i * 10);
            resultHandlers.add(handler);
        }
        WorkflowSetting firstSetting = settings.get(0);
        firstSetting.setCarbonCopy(Integer.valueOf(1));
        carbonCopy.add(WorkflowHandler.of("oa_admin", firstSetting));
        if (!carbonCopy.isEmpty()) {
            resultHandlers.addAll(carbonCopy);
        }
        return resultHandlers;
    }

    private List<WorkflowSetting> getWorkflowSetting(String wfid, UnaryOperator<List<WorkflowSetting>>[] operators) {
        List settings = this.workflowSettingService.getWorkflowSetting(wfid);
        if (ArrayMapTools.isEmpty(settings)) {
            throw new NullPointerException("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f : [" + wfid + "]");
        }
        if (ArrayMapTools.isEmpty((Object[])operators)) {
            return settings;
        }
        for (UnaryOperator<List<WorkflowSetting>> operator : operators) {
            if (null == operator || !ArrayMapTools.isEmpty((Collection)(settings = (List)operator.apply(settings)))) continue;
            throw new NullPointerException("\u65e0\u6cd5\u627e\u5230\u6d41\u7a0b\u914d\u7f6e\u4fe1\u606f : [" + wfid + "]");
        }
        return settings;
    }

    private void addWorkflowHandler(User user, Company company, WorkAddress workAddress, List<WorkflowHandler> handlers, WorkflowSetting workflowSetting, String hr) {
        if (WorkflowType.superior.equalsName(workflowSetting.getType())) {
            if (workflowSetting.getCarbonCopy() > 0) {
                List<String> carbonCopyUids = this.userProxy.getLeadersWithoutCEO(user.getSuperiorId());
                if (ArrayMapTools.isNotEmpty(carbonCopyUids)) {
                    carbonCopyUids.forEach(it -> handlers.add(WorkflowHandler.of(it, workflowSetting)));
                }
                return;
            }
            this.addSuperiorHandlers(user, workflowSetting, handlers);
        } else if (WorkflowType.finance.equalsName(workflowSetting.getType())) {
            this.addFinanceHandlers(company.getAccounter(), workflowSetting, handlers);
        } else if (WorkflowType.administration_countersign.equalsName(workflowSetting.getType())) {
            this.addAdmCountersign(workAddress.getTimekeeper(), workflowSetting, handlers);
        } else if (WorkflowType.hr_countersign.equalsName(workflowSetting.getType())) {
            this.addHrCountersign(hr, workflowSetting, handlers);
        } else if (WorkflowType.law.equalsName(workflowSetting.getType())) {
            this.addLawHandler(company.getLaw(), workflowSetting, handlers);
        } else if (WorkflowType.hr.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(hr, workflowSetting));
        } else if (WorkflowType.cashier.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getCashier(), workflowSetting));
        } else if (WorkflowType.assets_it.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getAssetsKeeperIt(), workflowSetting));
        } else if (WorkflowType.assets_work.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(company.getAssetsKeeperWork(), workflowSetting));
        } else if (WorkflowType.attendancer.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(workAddress.getTimekeeper(), workflowSetting));
        } else if (WorkflowType.cao.equalsName(workflowSetting.getType())) {
            this.addCaoHandler(workflowSetting, handlers);
        } else if (WorkflowType.ceo.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of("ohtwbdzdbqvbrlwl", workflowSetting));
        } else if (WorkflowType.self.equalsName(workflowSetting.getType())) {
            handlers.add(WorkflowHandler.of(user.getUid(), workflowSetting));
        } else if (WorkflowType.cio.equalsName(workflowSetting.getType())) {
            this.addCioHandler(workflowSetting, handlers);
        }
    }

    private void addSuperiorHandlers(User user, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        List<String> leaders;
        if (StringTools.isEmptyAndBlank((String)user.getSuperiorId())) {
            return;
        }
        handlers.add(WorkflowHandler.of(user.getSuperiorId(), workflowSetting, true));
        if ("ohtwbdzdbqvbrlwl".equals(user.getSuperiorId())) {
            return;
        }
        if (workflowSetting.getIsExt() > 0) {
            workflowSetting.setIsExt(Integer.valueOf(0));
        }
        if (ArrayMapTools.isEmpty(leaders = this.userProxy.getLeadersWithoutCEO(user.getSuperiorId()))) {
            return;
        }
        for (String superior : leaders) {
            handlers.add(WorkflowHandler.of(superior, workflowSetting, true));
        }
    }

    private void addFinanceHandlers(String accounter, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        handlers.add(WorkflowHandler.of(accounter, workflowSetting, true));
        List<String> financeLeaders = this.userProxy.getLeadersWithoutCEO(accounter);
        if (ArrayMapTools.isEmpty(financeLeaders)) {
            return;
        }
        if (workflowSetting.getIsExt() > 0) {
            workflowSetting.setIsExt(Integer.valueOf(0));
        }
        for (String leader : financeLeaders) {
            handlers.add(WorkflowHandler.of(leader, workflowSetting, true));
        }
    }

    private void addAdmCountersign(String adm, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        handlers.add(WorkflowHandler.of(adm, workflowSetting, true));
        this.addCaoHandler(workflowSetting, handlers);
    }

    private void addCaoHandler(WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        User cao = this.userService.getUserByPosition("jeeybrjhq2ustyx1");
        if (null == cao) {
            return;
        }
        handlers.add(WorkflowHandler.of(cao.getUid(), workflowSetting, true));
    }

    private void addCioHandler(WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        User cio = this.userService.getUserByPosition("r06hdu31hjndodne");
        if (null == cio) {
            return;
        }
        handlers.add(WorkflowHandler.of(cio.getUid(), workflowSetting, true));
    }

    private void addHrCountersign(String hrId, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        handlers.add(WorkflowHandler.of(hrId, workflowSetting, true));
        User cho = this.userService.getUserByPosition("4y2i4nqhvyroskir");
        if (null == cho) {
            return;
        }
        handlers.add(WorkflowHandler.of(cho.getUid(), workflowSetting, true));
    }

    private void addLawHandler(String lawId, WorkflowSetting workflowSetting, List<WorkflowHandler> handlers) {
        handlers.add(WorkflowHandler.of(lawId, workflowSetting, true));
        User lawUser = this.userService.getSimpleUser(lawId);
        if (null == lawUser || StringTools.isEmptyAndBlank((String)lawUser.getSuperiorId())) {
            return;
        }
        handlers.add(WorkflowHandler.of(lawUser.getSuperiorId(), workflowSetting, true));
    }

    public String getIdentify() {
        long timeInMillis = Calendar.getInstance().getTimeInMillis();
        String today = TimeTools.getDateTime((long)timeInMillis, (String)"yyyyMMddHHmmssSSS");
        String identity = this.workflowIdentifyCache.getWorkflowIdentity();
        return today + this.append(identity, 25 - today.length());
    }

    private String append(String a, int length) {
        if (a.length() >= length) {
            return a;
        }
        return this.append("0" + a, length);
    }
}

