/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.repository.OAUserRepository;
import com.jz.jar.oa.repository.UserPositionHistoryRepository;
import com.jz.jar.oa.repository.UserRewardsAndPunishmentRepository;
import com.jz.jar.oa.repository.UserSkillRepository;
import com.jz.jar.oa.repository.UserTrainingRepository;
import com.jz.jar.oa.repository.UserWelfareRepository;
import com.jz.jooq.oa.tables.pojos.User;
import com.jz.jooq.oa.tables.pojos.UserPositionHistory;
import com.jz.jooq.oa.tables.pojos.UserRewardsAndPunishment;
import com.jz.jooq.oa.tables.pojos.UserSkill;
import com.jz.jooq.oa.tables.pojos.UserTraining;
import com.jz.jooq.oa.tables.pojos.UserWelfare;
import com.jz.jooq.oa.tables.records.UserPositionHistoryRecord;
import com.jz.jooq.oa.tables.records.UserRecord;
import com.jz.jooq.oa.tables.records.UserRewardsAndPunishmentRecord;
import com.jz.jooq.oa.tables.records.UserSkillRecord;
import com.jz.jooq.oa.tables.records.UserTrainingRecord;
import com.jz.jooq.oa.tables.records.UserWelfareRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class OAUserService {
    @Autowired
    private OAUserRepository userRepository;
    @Autowired
    private UserSkillRepository userSkillRepository;
    @Autowired
    private UserWelfareRepository userWelfareRepository;
    @Autowired
    private UserTrainingRepository userTrainingRepository;
    @Autowired
    private UserRewardsAndPunishmentRepository userRewardsAndPunishmentRepository;
    @Autowired
    private UserPositionHistoryRepository userPositionHistoryRepository;

    public void insUpdateUser(String uid, String chineseName, String englishName, String phone, String companyId, String workAddrId, String deptId, String positionId, String superiorId, String joinDate, String relations, Integer insurance, Integer childFree, Integer trainAgreement, Integer annualLeaveDays, String certificate, int status) {
        this.userRepository.insUpdateUser(uid, chineseName, englishName, phone, companyId, workAddrId, deptId, positionId, superiorId, joinDate, relations, insurance, childFree, trainAgreement, annualLeaveDays, certificate, status);
    }

    public void updateUserStatus(String uid, int status) {
        Preconditions.checkArgument((status == 1 || status == 2 ? 1 : 0) != 0, (Object)"status\u53c2\u6570\u9519\u8bef");
        this.userRepository.updateUserStatus(uid, status);
    }

    public User getUser(String uid) {
        return this.userRepository.getUser(uid);
    }

    public User getUserInfo(String uid) {
        return this.userRepository.getUserInfo(uid);
    }

    public Map<String, User> mutiGetUserMap(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> mutGetAllUsers(Collection<String> uids) {
        List<User> list = this.userRepository.mutGetAllUsers(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> multiGetSimpleUser(Collection<String> uids) {
        List<User> users = this.userRepository.multiGetSimpleUser(uids);
        if (ArrayMapTools.isEmpty(users)) {
            return Maps.newHashMap();
        }
        return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public Map<String, User> multiGetAllSimpleUser(Collection<String> uids) {
        List<User> users = this.userRepository.multiGetAllSimpleUser(uids);
        if (ArrayMapTools.isEmpty(users)) {
            return Maps.newHashMap();
        }
        return users.stream().collect(Collectors.toMap(it -> it.getUid(), it -> it));
    }

    public User getSimpleUser(String uid) {
        return this.userRepository.getSimpleUser(uid);
    }

    public Map<String, Integer> getStaffNumByCompanyIds(Set<String> companyIds) {
        return this.userRepository.getStaffNumByCompanyIds(companyIds);
    }

    public boolean isIncumbency(String uid) {
        return this.userRepository.isIncumbency(uid);
    }

    public int cntCompanyUser(String id) {
        return this.userRepository.cntCompanyUser(id);
    }

    public int cntDeptUser(String deptId) {
        return this.userRepository.cntDeptUser(deptId);
    }

    public int cntPositionUser(String id) {
        return this.userRepository.cntPositionUser(id);
    }

    public Map<String, Integer> getStaffNumByWorkAddressIds(Set<String> workAddressIds) {
        return this.userRepository.getStaffNumByWorkAddressIds(workAddressIds);
    }

    public int cntWorkAddressUser(String id) {
        return this.userRepository.cntWorkAddressUser(id);
    }

    public int cntAllWorkAddressUser(String workAddrId) {
        return this.userRepository.cntAllWorkAddressUser(workAddrId);
    }

    public Map<String, Integer> getStaffNumByDeptIds(Set<String> deptIds) {
        return this.userRepository.getStaffNumByDeptIds(deptIds);
    }

    public void updateUserPosition(String id) {
        this.userRepository.updateUserPosition(id);
    }

    public void updateUserCompany(String id) {
        this.userRepository.updateUserCompany(id);
    }

    public void updateUserDept(String deptId) {
        this.userRepository.updateUserDept(deptId);
    }

    public List<User> getUserInfoPage(String companyId, String keyword, int start, int size) {
        return this.userRepository.getUserInfoPage(companyId, keyword, start, size);
    }

    public User getUserByPosition(String positionId) {
        return this.userRepository.getUserByPosition(positionId);
    }

    public List<String> getDeptIdsForCompany(String companyId) {
        return this.userRepository.getDeptIdsForCompany(companyId);
    }

    public List<User> getUsersForDepartment(String companyId, String deptId) {
        return this.userRepository.getUsersForDepartment(companyId, deptId);
    }

    public User getUserByPhone(String phone) {
        return this.userRepository.getUserByPhone(phone);
    }

    public String getSuperiorUid(String uid) {
        return this.userRepository.getSuperiorUid(uid);
    }

    public void updateSuperior(String currentlySuperior, String newSuperior) {
        this.userRepository.updateSuperior(currentlySuperior, newSuperior);
    }

    public List<User> getUsersForWorkAddress(String workAddrId, int start, int size) {
        return this.userRepository.getUsersForWorkAddress(workAddrId, start, size);
    }

    public List<String> filterUidsByConditionsLimit(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds, int start, int size) {
        return this.userRepository.filterUidsByConditionsLimit(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds, start, size);
    }

    public int cntUsersByConditions(String uid, String departmentId, String companyId, String workAddrId, String keyword, Collection<String> filterWorkAddrIds, Collection<String> filterCompanyIds) {
        return this.userRepository.cntUsersByConditions(uid, departmentId, companyId, workAddrId, keyword, filterWorkAddrIds, filterCompanyIds);
    }

    public int cntUsers(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword) {
        return this.userRepository.cntUsers(uid, status, departmentId, companyId, workAddrId, keyword);
    }

    public List<User> filterUsersByConditionsLimit(String uid, int status, String departmentId, String companyId, String workAddrId, String keyword, int start, int size) {
        return this.userRepository.filterUsersByConditionsLimit(uid, status, departmentId, companyId, workAddrId, keyword, start, size);
    }

    public List<User> getHrList(List<String> hrs) {
        return this.userRepository.getHrList(hrs);
    }

    public List<String> findUserIdForWorkAddress(Collection<String> workAddressIds) {
        return this.userRepository.findUserIdForWorkAddress(workAddressIds);
    }

    public List<String> getCompanyForUser(Collection<String> uids) {
        return this.userRepository.getCompanyForUser(uids);
    }

    public void changeToResignation(String uid, int status, String resignationDate) {
        this.userRepository.changeToResignation(uid, status, resignationDate);
    }

    public List<String> filterUids(String keyword) {
        return this.userRepository.filterUids(keyword);
    }

    public List<String> getUsersByPosition(String positionId) {
        return this.userRepository.getUsersByPosition(positionId);
    }

    public void createUser(UserRecord record) {
        this.userRepository.createUser(record);
    }

    public void updateUser(String fuid, String chineseName, String englishName, String phone, int status, String cardType, String cardBak, String nationality, String country, String fertility, String residenceType, String residenceAddress, String contactAddress, String landline, String emergencyContact, String emergencyPhone, Integer insurance, Integer childFree, Integer trainAgreement, String joinDate) {
        this.userRepository.updateUser(fuid, chineseName, englishName, phone, status, cardType, cardBak, nationality, country, fertility, residenceType, residenceAddress, contactAddress, landline, emergencyContact, emergencyPhone, insurance, childFree, trainAgreement, joinDate);
    }

    public void updateUserPositionInfo(String fuid, String joinChannel, String referrer, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature, String deptId, String positionId, String superiorId, String relations, String workAddrId, String companyId, String laborUnion, String costCenter) {
        this.userRepository.updateUserPositionInfo(fuid, joinChannel, referrer, officialJoinDate, contractStart, contractEnd, contractType, contractNature, deptId, positionId, superiorId, relations, workAddrId, companyId, laborUnion, costCenter);
    }

    public void updateUserSkills(String fuid, List<UserSkillRecord> skillRecords) {
        this.userSkillRepository.updateUserSkills(fuid, skillRecords);
    }

    public void updateBackgroundSurvey(String fuid, String backgroundSurvey) {
        this.userRepository.updateBackgroundSurvey(fuid, backgroundSurvey);
    }

    public void updateUserAccountInfo(String fuid, String bankAccount, String bank, String bankArea, String fund, String socialSecurityType, String socialSecurityArea, String tax, Integer annualLeaveDays, String certificate) {
        this.userRepository.updateUserAccountInfo(fuid, bankAccount, bank, bankArea, fund, socialSecurityType, socialSecurityArea, tax, annualLeaveDays, certificate);
    }

    public void updateUserWelfare(String fuid, List<UserWelfareRecord> welfareRecords) {
        this.userWelfareRepository.updateUserWelfare(fuid, welfareRecords);
    }

    public void updateUserTraining(String fuid, List<UserTrainingRecord> trainingRecords) {
        this.userTrainingRepository.updateUserTraining(fuid, trainingRecords);
    }

    public void updateUserRewardsAndPunishment(String fuid, List<UserRewardsAndPunishmentRecord> rpRecords) {
        this.userRewardsAndPunishmentRepository.updateUserRewardsAndPunishment(fuid, rpRecords);
    }

    public void updateUserPositionHistory(String fuid, List<UserPositionHistoryRecord> positionRecords) {
        this.userPositionHistoryRepository.updateUserPositionHistory(fuid, positionRecords);
    }

    public List<UserSkill> getUserSkills(String fuid) {
        return this.userSkillRepository.getUserSkills(fuid);
    }

    public List<UserWelfare> getUserWelfares(String fuid) {
        return this.userWelfareRepository.getUserWelfares(fuid);
    }

    public List<UserTraining> getUserTrainings(String fuid) {
        return this.userTrainingRepository.getUserTrainings(fuid);
    }

    public List<UserRewardsAndPunishment> getUserRewardsAndPunishments(String fuid) {
        return this.userRewardsAndPunishmentRepository.getUserRewardsAndPunishments(fuid);
    }

    public List<UserPositionHistory> getUserPositionHistorys(String fuid) {
        return this.userPositionHistoryRepository.getUserPositionHistorys(fuid);
    }

    public void backInOffice(String fuid, String joinDate, String officialJoinDate, String contractStart, String contractEnd, String contractType, String contractNature) {
        this.userRepository.backInOffice(fuid, joinDate, officialJoinDate, contractStart, contractEnd, contractType, contractNature);
    }

    public void createUserTraining(String fuid, String name, String type, Long startTime, Long endTime, int status, String remark, String certificate) {
        List<UserTraining> userTrainings = this.userTrainingRepository.getUserTrainings(fuid);
        this.userTrainingRepository.createUserTraining(fuid, userTrainings.size() + 1, name, type, startTime, endTime, status, remark, certificate);
    }

    public Map<String, List<String>> multiGetWorkAddrUids(Collection<String> uids) {
        HashMap map = Maps.newHashMap();
        List<User> list = this.userRepository.multiGetUserAddr(uids);
        if (ArrayMapTools.isEmpty(list)) {
            return Maps.newHashMap();
        }
        for (User u : list) {
            if (map.containsKey(u.getWorkAddrId())) {
                ((List)map.get(u.getWorkAddrId())).add(u.getUid());
                continue;
            }
            map.put(u.getWorkAddrId(), Lists.newArrayList((Object[])new String[]{u.getUid()}));
        }
        return map;
    }
}

