package com.jz.jar.oa.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.wrapper.WorkflowHandler;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowHandler;
import com.jz.jooq.oa.tables.records.UserWorkflowHandlerRecord;

@Lazy
@Repository
public class UserWorkflowHandlerRepository extends OABaseRepository {

	private static final com.jz.jooq.oa.tables.UserWorkflowHandler HANDLER = Tables.USER_WORKFLOW_HANDLER;

	public void addUserWorkflowHandlers(String identify, Collection<WorkflowHandler> handlers) {
		long timeMillis = System.currentTimeMillis();
		List<UserWorkflowHandlerRecord> handlerRecords = Lists.newArrayList();
		for (WorkflowHandler workflowHandler : handlers) {
			if (workflowHandler.getIsCarbonCopy())
				continue;
			UserWorkflowHandlerRecord handlerRecord = new UserWorkflowHandlerRecord();
			handlerRecord.setUwfid(identify);
			handlerRecord.setUid(workflowHandler.getUid());
			handlerRecord.setHandleName(workflowHandler.getHandleName());
			handlerRecord.setStep(workflowHandler.getStep());
			handlerRecord.setExtType(workflowHandler.getExtType());
			handlerRecord.setLastUpdate(timeMillis);
			handlerRecords.add(handlerRecord);
		}
		oaCtx.batchInsert(handlerRecords).execute();
	}

	public List<UserWorkflowHandler> getUserWorkflowHandleInfos(String identify) {
		return oaCtx.selectFrom(HANDLER).where(HANDLER.UWFID.eq(identify)).orderBy(HANDLER.STEP.asc())
				.fetchInto(UserWorkflowHandler.class);
	}

	public void updateHandleInfo(String identify, String uid, Integer step, String position, UserWorkflow result,
			String remarks) {
		oaCtx.update(HANDLER).set(HANDLER.POSITION_NAME, position).set(HANDLER.RESULT, result.getCode())
				.set(HANDLER.REMARKS, remarks).set(HANDLER.LAST_UPDATE, System.currentTimeMillis())
				.where(HANDLER.UWFID.eq(identify).and(HANDLER.UID.eq(uid)).and(HANDLER.STEP.eq(step))).execute();
	}

	public void addUserWorkflowHandler(String identify, String uid, String handleName, int step, String reason) {
		UserWorkflowHandlerRecord handlerRecord = new UserWorkflowHandlerRecord();
		handlerRecord.setUwfid(identify);
		handlerRecord.setUid(uid);
		handlerRecord.setHandleName(handleName);
		handlerRecord.setStep(step);
		handlerRecord.setReason(reason);
		handlerRecord.setLastUpdate(System.currentTimeMillis());
		oaCtx.insertInto(HANDLER).set(handlerRecord).execute();
	}

	public UserWorkflowHandler getUserWorkflowHandleInfo(String identify, String uid, Integer step) {
		return oaCtx.selectFrom(HANDLER)
				.where(HANDLER.UWFID.eq(identify).and(HANDLER.UID.eq(uid)).and(HANDLER.STEP.eq(step)))
				.fetchAnyInto(UserWorkflowHandler.class);
	}

	public boolean isExistCurrentUser(String identify, String uid) {
		return oaCtx.fetchExists(HANDLER, HANDLER.UWFID.eq(identify).and(HANDLER.UID.eq(uid)));
	}

	public void cleanUserWorkflowHandles(String identify) {
		oaCtx.deleteFrom(HANDLER).where(HANDLER.UWFID.eq(identify)).execute();
	}

	public List<String> getHandledByMe(String uid, int code, List<String> allUwfids) {
		return oaCtx.select(HANDLER.UWFID).from(HANDLER)
				.where(HANDLER.UWFID.in(allUwfids).and(HANDLER.UID.eq(uid).and(HANDLER.RESULT.eq(code))))
				.fetchInto(String.class);
	}

	public List<String> getUwfidsNeedUid(String uid) {
		return oaCtx.select(HANDLER.UWFID).from(HANDLER).where(HANDLER.UID.eq(uid).and(HANDLER.RESULT.isNull()))
				.fetchInto(String.class);
	}

	public void updateHandler(List<String> uwfids, String uid, String taker) {
		oaCtx.update(HANDLER).set(HANDLER.UID, taker)
				.where(HANDLER.UWFID.in(uwfids).and(HANDLER.UID.eq(uid)).and(HANDLER.RESULT.isNull())).execute();
	}
}
