/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Lists;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.UserWorkflowAuditLog;
import com.jz.jooq.oa.tables.pojos.UserWorkflowAuditAttachmentLog;
import com.jz.jooq.oa.tables.records.UserWorkflowAuditAttachmentLogRecord;
import com.jz.jooq.oa.tables.records.UserWorkflowAuditLogRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jooq.Condition;
import org.jooq.Record;
import org.jooq.Table;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserWorkflowAuditLogRepository
extends OABaseRepository {
    private static final UserWorkflowAuditLog L = Tables.USER_WORKFLOW_AUDIT_LOG;
    private static final com.jz.jooq.oa.tables.UserWorkflowAuditAttachmentLog AL = Tables.USER_WORKFLOW_AUDIT_ATTACHMENT_LOG;

    public void addAuditLog(String id, String uwfid, String operator, String handleName, String positionName, Integer step, UserWorkflow result, String remarks, String reason, String extType) {
        UserWorkflowAuditLogRecord record = new UserWorkflowAuditLogRecord();
        record.setId(id);
        record.setUwfid(uwfid);
        record.setOperator(operator);
        record.setHandleName(handleName);
        record.setPositionName(positionName);
        record.setStep(step);
        record.setResult(Integer.valueOf(result.getCode()));
        record.setRemarks(remarks);
        record.setReason(reason);
        record.setExtType(extType);
        record.setCreateTime(Long.valueOf(System.currentTimeMillis()));
        this.oaCtx.insertInto((Table)L).set((Record)record).onDuplicateKeyUpdate().set((Record)record).execute();
    }

    public void addUserWorkflowAttachmentLog(String logId, Map<String, String> attachmentName2Path) {
        ArrayList attachmentRecords = Lists.newArrayList();
        attachmentName2Path.forEach((name, url) -> attachmentRecords.add(new UserWorkflowAuditAttachmentLogRecord(null, logId, name, url)));
        this.oaCtx.batchInsert((Collection)attachmentRecords).execute();
    }

    public List<com.jz.jooq.oa.tables.pojos.UserWorkflowAuditLog> getUserWorkflowAuditLogs(String uwfid) {
        return this.oaCtx.selectFrom((Table)L).where(new Condition[]{UserWorkflowAuditLogRepository.L.UWFID.eq((Object)uwfid)}).orderBy(UserWorkflowAuditLogRepository.L.CREATE_TIME.asc()).fetchInto(com.jz.jooq.oa.tables.pojos.UserWorkflowAuditLog.class);
    }

    public List<UserWorkflowAuditAttachmentLog> mutiGetAttachmentsLog(Set<String> logIds) {
        return this.oaCtx.selectFrom((Table)AL).where(new Condition[]{UserWorkflowAuditLogRepository.AL.LOG_ID.in(logIds)}).fetchInto(UserWorkflowAuditAttachmentLog.class);
    }
}

