/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.oa.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.oa.enmus.UserWorkflow;
import com.jz.jar.oa.repository.OABaseRepository;
import com.jz.jooq.oa.Tables;
import com.jz.jooq.oa.tables.pojos.UserWorkflowInfo;
import com.jz.jooq.oa.tables.records.UserWorkflowInfoRecord;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Record;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.UpdateSetMoreStep;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class UserWorkflowInfoRepository
extends OABaseRepository {
    private static final com.jz.jooq.oa.tables.UserWorkflowInfo UWFI = Tables.USER_WORKFLOW_INFO;

    public void addOrUpdateUserWorkflowInfo(String identify, String uid, String wfid, String companyId, String workAddrId, String title, String reason, String handler, Integer nextStep, String remarks, UserWorkflow workflowStatus) {
        long timeMillis = System.currentTimeMillis();
        UserWorkflowInfoRecord workflowInfoRecord = new UserWorkflowInfoRecord();
        workflowInfoRecord.setId(identify);
        workflowInfoRecord.setUid(uid);
        workflowInfoRecord.setWfid(wfid);
        workflowInfoRecord.setCompanyId(companyId);
        workflowInfoRecord.setWorkAddrId(workAddrId);
        workflowInfoRecord.setTitle(title);
        workflowInfoRecord.setReason(reason);
        workflowInfoRecord.setHandler(handler);
        workflowInfoRecord.setNextStep(nextStep);
        workflowInfoRecord.setStatus(Integer.valueOf(workflowStatus.getCode()));
        workflowInfoRecord.setResult(null);
        workflowInfoRecord.setRemarks(remarks);
        workflowInfoRecord.setCreateTime(Long.valueOf(timeMillis));
        workflowInfoRecord.setLastUpdate(Long.valueOf(timeMillis));
        this.oaCtx.insertInto((Table)UWFI).set((Record)workflowInfoRecord).onDuplicateKeyUpdate().set((Record)workflowInfoRecord).execute();
    }

    public Condition getWhereCondition(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, Collection<String> nickUwfids, Integer flowCode) {
        Condition condition = UserWorkflowInfoRepository.UWFI.ID.in(uwfids);
        if (StringUtils.isNotEmpty((CharSequence)keyword)) {
            condition = condition.and(DSL.or((Condition[])new Condition[]{UserWorkflowInfoRepository.UWFI.TITLE.like("%" + keyword + "%"), UserWorkflowInfoRepository.UWFI.ID.like("%" + keyword + "%")}));
        }
        if (startTime != null && endTime != null) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.CREATE_TIME.between((Object)startTime, (Object)endTime));
        }
        if (flowCode != null) {
            condition = flowCode == 99 ? condition.and(UserWorkflowInfoRepository.UWFI.STATUS.in((Object[])new Integer[]{UserWorkflow.INFO_ING.getCode(), UserWorkflow.INFO_FINISHED.getCode()})) : condition.and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)flowCode));
        }
        if (StringUtils.isNotEmpty((CharSequence)nickname) && ArrayMapTools.isNotEmpty(nickUwfids)) {
            condition = condition.and(UserWorkflowInfoRepository.UWFI.ID.in(nickUwfids));
        }
        return condition;
    }

    public int cntWorkflows(List<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, Collection<String> nickUwfids, Integer flowCode) {
        return this.oaCtx.fetchCount((Table)UWFI, this.getWhereCondition(uwfids, keyword, startTime, endTime, nickname, nickUwfids, flowCode));
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids, String keyword, Long startTime, Long endTime, String nickname, Collection<String> nickUwfids, int start, int size, Integer flowCode) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{this.getWhereCondition(uwfids, keyword, startTime, endTime, nickname, nickUwfids, flowCode)}).orderBy(UserWorkflowInfoRepository.UWFI.ID.desc()).limit(start, size).fetchInto(UserWorkflowInfo.class);
    }

    public UserWorkflowInfo getUserWorkflowInfo(String id) {
        return (UserWorkflowInfo)this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)id)}).fetchAnyInto(UserWorkflowInfo.class);
    }

    public void updateHandleInfo(String id, String handler, Integer step, UserWorkflow status, UserWorkflow result) {
        UpdateSetMoreStep moreStep = this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.HANDLER, (Object)handler).set((Field)UserWorkflowInfoRepository.UWFI.NEXT_STEP, (Object)step).set((Field)UserWorkflowInfoRepository.UWFI.LAST_UPDATE, (Object)System.currentTimeMillis());
        if (null != status) {
            moreStep = moreStep.set((Field)UserWorkflowInfoRepository.UWFI.STATUS, (Object)status.getCode());
        }
        if (null != result) {
            moreStep = moreStep.set((Field)UserWorkflowInfoRepository.UWFI.RESULT, (Object)result.getCode());
        }
        moreStep.where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)id)}).execute();
    }

    public Map<String, Integer> getStatusMap(String uid) {
        List maps = this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.STATUS.as("status"), (SelectField)DSL.count().as("cnt")).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid)}).groupBy(new GroupField[]{UserWorkflowInfoRepository.UWFI.STATUS}).fetchMaps();
        HashMap rsMap = Maps.newHashMap();
        if (ArrayMapTools.isNotEmpty((Collection)maps)) {
            Integer all = 0;
            for (Map it : maps) {
                if (MapUtils.getString((Map)it, (Object)"status").equals("1")) {
                    all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
                    rsMap.put("going", MapUtils.getInteger((Map)it, (Object)"cnt"));
                    continue;
                }
                if (MapUtils.getString((Map)it, (Object)"status").equals("2")) {
                    all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
                    rsMap.put("end", MapUtils.getInteger((Map)it, (Object)"cnt"));
                    continue;
                }
                all = all + MapUtils.getInteger((Map)it, (Object)"cnt");
            }
            rsMap.put("all", all);
        }
        return rsMap;
    }

    public String getLatestPassedWorkflowId(String uid, String wfid) {
        return (String)this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)wfid)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).orderBy(UserWorkflowInfoRepository.UWFI.LAST_UPDATE.desc()).fetchAnyInto(String.class);
    }

    public List<String> mutiGetUserWorkflowIds(String uid, String name) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)name)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).fetchInto(String.class);
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflows(String uid, String name) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)name)).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).fetchInto(UserWorkflowInfo.class);
    }

    public List<String> getUserLeaveWorkflowInProgress(String uid, String workflowKey) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.UID.eq((Object)uid).and(UserWorkflowInfoRepository.UWFI.WFID.eq((Object)workflowKey).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_ING.getCode())))}).fetchInto(String.class);
    }

    public void updateBackModifyToNormal(String uwfid, String remarks) {
        Object _null = null;
        this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.RESULT, _null).set((Field)UserWorkflowInfoRepository.UWFI.REMARKS, (Object)remarks).set((Field)UserWorkflowInfoRepository.UWFI.LAST_UPDATE, (Object)System.currentTimeMillis()).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.eq((Object)uwfid)}).execute();
    }

    public List<String> mutiGetAllAssetReportIds(String uid, String name) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.WFID.eq((Object)name).and(UserWorkflowInfoRepository.UWFI.RESULT.eq((Object)UserWorkflow.RESULT_PASS.getCode())).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_FINISHED.getCode()))}).fetchInto(String.class);
    }

    public List<UserWorkflowInfo> mutiGetUserWorkflowInfos(Collection<String> uwfids) {
        return this.oaCtx.selectFrom((Table)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfids)}).fetchInto(UserWorkflowInfo.class);
    }

    public List<String> getUwfidsInProgressNeedUid(List<String> uwfidsNeedUid) {
        return this.oaCtx.select((SelectField)UserWorkflowInfoRepository.UWFI.ID).from((TableLike)UWFI).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfidsNeedUid).and(UserWorkflowInfoRepository.UWFI.STATUS.eq((Object)UserWorkflow.INFO_ING.getCode()))}).fetchInto(String.class);
    }

    public void updateHandler(List<String> uwfids, String uid, String taker) {
        this.oaCtx.update((Table)UWFI).set((Field)UserWorkflowInfoRepository.UWFI.HANDLER, (Object)taker).where(new Condition[]{UserWorkflowInfoRepository.UWFI.ID.in(uwfids).and(UserWorkflowInfoRepository.UWFI.HANDLER.eq((Object)uid))}).execute();
    }
}

