package com.jz.jar.oa.enmus;

/**
 * @Title WorkflowType
 * @Package com.jz.jar.oa.enmus
 * @author tangjunfeng
 * @date 2019年3月25日 下午3:17:21
 * @version V1.0
 */
public enum WorkflowType {

	self("申请人"), 
	superior("部门审核"), 
	hr("HR"), 
	finance("财务审核"), 
	ceo("董事长审核"), 
	cashier("出纳审核"),
	law("法务审核"), 
	assets_it("IT-资产管理人审核"), 
	assets_work("办公-资产管理人审核"), 
	attendancer("行政审核"), 
	cao("行政总监审核"), 
	hr_countersign("人事会签"), 
	administration_countersign("行政会签");

	private String desc;

	WorkflowType(String desc) {
		this.desc = desc;
	}

	public String getDesc() {
		return desc;
	}

	public boolean equalsName(String name) {
		return this.name().equals(name);
	}

	public static boolean containsName(String name) {
		for (WorkflowType type : WorkflowType.values()) {
			if (type.equalsName(name))
				return true;
		}
		return false;
	}
}
